\                   PCI expansion PROM header
\        00000000:                              PCI magic number (55AA): 55AA
\        00000002:                             Pointer to FCode program: 0040
\        00000004:      Reserved for processor architecture-unique data: 00000000 00000000 00000000 00000000 00000000  ....................
\        00000018:               Pointer to start of PCI Data Structure: 0020
\        0000001A:                                            Pad bytes: 0000
\                                             Variable length pad bytes:
\        0000001C: 00000000                                                                 ....
\                   PCI Data Structure (4 byte aligned)
\        00000020:                              Signature string (PCIR): PCIR
\        00000024:                         Vendor ID = config reg 00/01: 9004
\        00000026:                         Device ID = config reg 02/03: 5078
\        00000028:                        Pointer to Vital Product Data: 0000
\        0000002A:                            PCI Data Structure length: 0020
\        0000002C:                          PCI Data Structure revision: 00 = PCI 2.2
\        0000002D:                     Class Code = config reg 09/0a/0b: 010000 (Class code / Subclass code / Programming interface code)
\        00000030:                            Image Length in 512 bytes: 0021 (* 0x200 = 0x4200)
\        00000032:                          Revision Level of Code/Data: 0000
\        00000034:                                            Code Type: 01 = Open Firmware
\        00000035:                                            Indicator: 80 = last image
\        00000036:                                             Reserved: 0000
\                                             Variable length pad bytes:
\        00000038: 00000000 00000000                                                        ........

hex

tokenizer[ 0000 ]tokenizer set-rev-level
tokenizer[ 0020 ]tokenizer pci-data-structure-start
tokenizer[ 0020 ]tokenizer pci-data-structure-length
tokenizer[ 9004 5078 010000 ]tokenizer pci-header
tokenizer[ 4200 ]tokenizer rom-size

fcode-version2																	\					[0f1]
\ format:    0x08
\ checksum:  0x8957 (ok)
\ len:       0x4107 (16647 bytes)
hex

" ADPT,2930CU"																	\					[012]
device-name																		\					[201]
" scsi"																			\					[012]
device-type																		\					[11a]
" ADPT,1686806-04"																\					[012]
model																			\					[119]
" ADPT,AIC-7856"																\					[012]
encode-string																	\					[114]
" compatible"																	\					[012]
property																		\					[110]
" 4.0"																			\					[012]
encode-string																	\					[114]
" ADPT,fcode-version"															\					[012]
property																		\					[110]
" 18-Jan-1999"																	\					[012]
encode-string																	\					[114]
" ADPT,fcode-date"																\					[012]
property																		\					[110]

headers

-1 constant 785x-6x?															\ (800 -1)			[0a4 0b6 0ba]
0 constant 788x?																\ (801 0)			[0a5 0b6 0ba]
0 constant 7890-91?																\ (802 0)			[0a5 0b6 0ba]
0 constant 7896-97?																\ (803 0)			[0a5 0b6 0ba]
-1 constant apple-max-transfer?													\ (804 -1)			[0a4 0b6 0ba]
1000 constant /scsi-regs														\ (805 1000)		[010 0b6 0ba]
0 value 789x?																	\ (806 0)			[0a5 0b6 0b8]
0 value #channels																\ (807 0)			[0a5 0b6 0b8]
0 value #targets																\ (808 0)			[0a5 0b6 0b8]
0 value /rom																	\ (809 0)			[0a5 0b6 0b8]
7896-97?																		\					[803]
if																				\ (0xa)				[014]
	2																			\					[0a7]
	to #channels																\					[0c3 807]
else																			\ (0x8)				[013 0b2]
	1																			\					[0a6]
	to #channels																\					[0c3 807]
then																			\					[0b2]
785x-6x?																		\					[800]
if																				\ (0xe)				[014]
	8																			\					[010]
	to #targets																	\					[0c3 808]
else																			\ (0xc)				[013 0b2]
	16																			\					[010]
	to #targets																	\					[0c3 808]
then																			\					[0b2]
7890-91?																		\					[802]
7896-97?																		\					[803]
or																				\					[024]
if																				\ (0x12)			[014]
	-1																			\					[0a4]
	to 789x?																	\					[0c3 806]
	20000																		\					[010]
	to /rom																		\					[0c3 809]
else																			\ (0x10)			[013 0b2]
	0																			\					[0a5]
	to 789x?																	\					[0c3 806]
	10000																		\					[010]
	to /rom																		\					[0c3 809]
then																			\					[0b2]
0 value debug?																	\ (80a 0)			[0a5 0b6 0b8]


external

: set-debug-mode																\ (80b)				[0ca 0b7]
	-1																			\					[0a4]
	to debug?																	\					[0c3 80a]
	;																			\					[0c2]

0																				\					[0a5]
0																				\					[0a5]
my-space																		\					[103]
encode-phys																		\					[113]
0																				\					[0a5]
encode-int																		\					[111]
encode+																			\					[112]
0																				\					[0a5]
encode-int																		\					[111]
encode+																			\					[112]
0																				\					[0a5]
0																				\					[0a5]
my-space																		\					[103]
2000014																			\					[010]
+																				\					[01e]
encode-phys																		\					[113]
encode+																			\					[112]
0																				\					[0a5]
encode-int																		\					[111]
encode+																			\					[112]
/scsi-regs																		\					[805]
encode-int																		\					[111]
encode+																			\					[112]
0																				\					[0a5]
0																				\					[0a5]
my-space																		\					[103]
2000030																			\					[010]
+																				\					[01e]
encode-phys																		\					[113]
encode+																			\					[112]
0																				\					[0a5]
encode-int																		\					[111]
encode+																			\					[112]
/rom																			\					[809]
encode-int																		\					[111]
encode+																			\					[112]
" reg"																			\					[012]
property																		\					[110]


headers

: warning																		\ (80c)				[0b6 0b7]
	debug?																		\					[80a]
	if																			\ (0x5)				[014]
		type																	\					[090]
		cr																		\					[092]
	then																		\					[0b2]
	" ADPT,warning"																\					[012]
	get-my-property																\					[21a]
	if																			\ (0x8)				[014]
		encode-string															\					[114]
	else																		\ (0xb)				[013 0b2]
		encode-bytes															\					[115]
		2swap																	\					[055]
		encode-string															\					[114]
		encode+																	\					[112]
	then																		\					[0b2]
	" ADPT,warning"																\					[012]
	property																	\					[110]
	;																			\					[0c2]


: my-l@																			\ (80d)				[0b6 0b7]
	my-space																	\					[103]
	+																			\					[01e]
	" config-l@"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: my-l!																			\ (80e)				[0b6 0b7]
	my-space																	\					[103]
	+																			\					[01e]
	" config-l!"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: my-w@																			\ (80f)				[0b6 0b7]
	my-space																	\					[103]
	+																			\					[01e]
	" config-w@"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: my-w!																			\ (810)				[0b6 0b7]
	my-space																	\					[103]
	+																			\					[01e]
	" config-w!"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: my-b@																			\ (811)				[0b6 0b7]
	my-space																	\					[103]
	+																			\					[01e]
	" config-b@"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: my-b!																			\ (812)				[0b6 0b7]
	my-space																	\					[103]
	+																			\					[01e]
	" config-b!"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: subsysid@																		\ (813)				[0b6 0b7]
	2e																			\					[010]
	my-w@																		\					[80f]
	;																			\					[0c2]


: get-base-address																\ (814)				[0b6 0b7]
	" assigned-addresses"														\					[012]
	get-my-property																\					[21a]
	if																			\ (0x25)			[014]
		." No address property found!"											\					[012 090]
		cr																		\					[092]
		0																		\					[0a5]
		0																		\					[0a5]
		rot																		\					[04a]
		exit																	\					[033]
	then																		\					[0b2]
	rot																			\					[04a]
	>r																			\					[030]
	begin																		\					[0b1]
		dup																		\					[047]
		while																	\ (0x29)			[014]
			decode-phys															\					[128]
			0ff																	\					[010]
			and																	\					[023]
			r@																	\					[032]
			0ff																	\					[010]
			and																	\					[023]
			=																	\					[03c]
			if																	\ (0xa)				[014]
				2swap															\					[055]
				2drop															\					[052]
				r>																\					[031]
				exit															\					[033]
			else																\ (0x5)				[013 0b2]
				2drop															\					[052]
			then																\					[0b2]
			decode-int															\					[21b]
			drop																\					[046]
			decode-int															\					[21b]
			drop																\					[046]
	repeat																		\ (0xffd8)			[013 0b2]
	2drop																		\					[052]
	." Base address not assigned!"												\					[012 090]
	cr																			\					[092]
	0																			\					[0a5]
	0																			\					[0a5]
	r>																			\					[031]
	;																			\					[0c2]



external

: map-in																		\ (815)				[0ca 0b7]
	" map-in"																	\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: map-out																		\ (816)				[0ca 0b7]
	" map-out"																	\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: dma-map-in																	\ (817)				[0ca 0b7]
	" dma-map-in"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: dma-alloc																		\ (818)				[0ca 0b7]
	" dma-alloc"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: dma-free																		\ (819)				[0ca 0b7]
	" dma-free"																	\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


headers

0 value io-base																	\ (81a 0)			[0a5 0b6 0b8]
0 value mem-base																\ (81b 0)			[0a5 0b6 0b8]

: map-io-regs																	\ (81c)				[0b6 0b7]
	0																			\					[0a5]
	0																			\					[0a5]
	my-space																	\					[103]
	1000010																		\					[010]
	+																			\					[01e]
	/scsi-regs																	\					[805]
	map-in																		\					[815]
	to io-base																	\					[0c3 81a]
	4																			\					[010]
	my-w@																		\					[80f]
	1																			\					[0a6]
	or																			\					[024]
	4																			\					[010]
	my-w!																		\					[810]
	;																			\					[0c2]


: unmap-io-regs																	\ (81d)				[0b6 0b7]
	io-base																		\					[81a]
	/scsi-regs																	\					[805]
	map-out																		\					[816]
	-1																			\					[0a4]
	to io-base																	\					[0c3 81a]
	4																			\					[010]
	my-w@																		\					[80f]
	1																			\					[0a6]
	invert																		\					[026]
	and																			\					[023]
	4																			\					[010]
	my-w!																		\					[810]
	;																			\					[0c2]


: map-mem-regs																	\ (81e)				[0b6 0b7]
	my-space																	\					[103]
	82000014																	\					[010]
	+																			\					[01e]
	get-base-address															\					[814]
	/scsi-regs																	\					[805]
	map-in																		\					[815]
	to mem-base																	\					[0c3 81b]
	4																			\					[010]
	my-w@																		\					[80f]
	6																			\					[010]
	or																			\					[024]
	4																			\					[010]
	my-w!																		\					[810]
	;																			\					[0c2]


: unmap-mem-regs																\ (81f)				[0b6 0b7]
	mem-base																	\					[81b]
	/scsi-regs																	\					[805]
	map-out																		\					[816]
	-1																			\					[0a4]
	to mem-base																	\					[0c3 81b]
	4																			\					[010]
	my-w@																		\					[80f]
	6																			\					[010]
	invert																		\					[026]
	and																			\					[023]
	4																			\					[010]
	my-w!																		\					[810]
	;																			\					[0c2]


: mem-b@																		\ (820)				[0b6 0b7]
	mem-base																	\					[81b]
	ca+																			\					[05e]
	rb@																			\					[230]
	;																			\					[0c2]


: mem-b!																		\ (821)				[0b6 0b7]
	mem-base																	\					[81b]
	ca+																			\					[05e]
	rb!																			\					[231]
	;																			\					[0c2]

0 value dummy-v																	\ (822 0)			[0a5 0b6 0b8]
0 value dummy-p																	\ (823 0)			[0a5 0b6 0b8]
20 value /dummy																	\ (824 20)			[010 0b6 0b8]

: get-phys-addr																	\ (825)				[0b6 0b7]
	?dup																		\					[050]
	if																			\ (0x9)				[014]
		0																		\					[0a5]
		dma-map-in																\					[817]
	else																		\ (0x7)				[013 0b2]
		drop																	\					[046]
		dummy-p																	\					[823]
	then																		\					[0b2]
	;																			\					[0c2]


: create-dummy																	\ (826)				[0b6 0b7]
	/dummy																		\					[824]
	dma-alloc																	\					[818]
	to dummy-v																	\					[0c3 822]
	dummy-v																		\					[822]
	/dummy																		\					[824]
	get-phys-addr																\					[825]
	to dummy-p																	\					[0c3 823]
	dummy-v																		\					[822]
	/dummy																		\					[824]
	erase																		\					[0a5 079]
	;																			\					[0c2]


: free-dummy																	\ (827)				[0b6 0b7]
	dummy-v																		\					[822]
	/dummy																		\					[824]
	dma-free																	\					[819]
	0																			\					[0a5]
	to dummy-p																	\					[0c3 823]
	0																			\					[0a5]
	to dummy-v																	\					[0c3 822]
	;																			\					[0c2]


: scsiseq@																		\ (828)				[0b6 0b7]
	0																			\					[0a5]
	mem-b@																		\					[820]
	;																			\					[0c2]


: scsiseq!																		\ (829)				[0b6 0b7]
	0																			\					[0a5]
	mem-b!																		\					[821]
	;																			\					[0c2]


: sxfrctl0@																		\ (82a)				[0b6 0b7]
	1																			\					[0a6]
	mem-b@																		\					[820]
	;																			\					[0c2]


: sxfrctl0!																		\ (82b)				[0b6 0b7]
	1																			\					[0a6]
	mem-b!																		\					[821]
	;																			\					[0c2]


: sxfrctl1@																		\ (82c)				[0b6 0b7]
	2																			\					[0a7]
	mem-b@																		\					[820]
	;																			\					[0c2]


: sxfrctl1!																		\ (82d)				[0b6 0b7]
	2																			\					[0a7]
	mem-b!																		\					[821]
	;																			\					[0c2]


: scsi-rate@																	\ (82e)				[0b6 0b7]
	4																			\					[010]
	mem-b@																		\					[820]
	;																			\					[0c2]


: scsi-rate!																	\ (82f)				[0b6 0b7]
	4																			\					[010]
	mem-b!																		\					[821]
	;																			\					[0c2]


: scsi-int0!																	\ (830)				[0b6 0b7]
	0b																			\					[010]
	mem-b!																		\					[821]
	;																			\					[0c2]


: scsi-stat0@																	\ (831)				[0b6 0b7]
	0b																			\					[010]
	mem-b@																		\					[820]
	;																			\					[0c2]


: scsi-int1!																	\ (832)				[0b6 0b7]
	0c																			\					[010]
	mem-b!																		\					[821]
	;																			\					[0c2]


: scsi-stat1@																	\ (833)				[0b6 0b7]
	0c																			\					[010]
	mem-b@																		\					[820]
	;																			\					[0c2]


: scsi-stat2@																	\ (834)				[0b6 0b7]
	0d																			\					[010]
	mem-b@																		\					[820]
	;																			\					[0c2]


: scsi-stat3@																	\ (835)				[0b6 0b7]
	0e																			\					[010]
	mem-b@																		\					[820]
	;																			\					[0c2]


: scsi-id-reg																	\ (836)				[0b6 0b7]
	7896-97?																	\					[803]
	if																			\ (0xb)				[014]
		0f																		\					[010]
	else																		\ (0x9)				[013 0b2]
		5																		\					[010]
	then																		\					[0b2]
	;																			\					[0c2]


: scsi-id@																		\ (837)				[0b6 0b7]
	scsi-id-reg																	\					[836]
	mem-b@																		\					[820]
	;																			\					[0c2]


: scsi-id!																		\ (838)				[0b6 0b7]
	scsi-id-reg																	\					[836]
	mem-b!																		\					[821]
	;																			\					[0c2]


: simode0@																		\ (839)				[0b6 0b7]
	10																			\					[010]
	mem-b@																		\					[820]
	;																			\					[0c2]


: simode0!																		\ (83a)				[0b6 0b7]
	10																			\					[010]
	mem-b!																		\					[821]
	;																			\					[0c2]


: simode1@																		\ (83b)				[0b6 0b7]
	11																			\					[010]
	mem-b@																		\					[820]
	;																			\					[0c2]


: simode1!																		\ (83c)				[0b6 0b7]
	11																			\					[010]
	mem-b!																		\					[821]
	;																			\					[0c2]


: brdctl@																		\ (83d)				[0b6 0b7]
	1d																			\					[010]
	mem-b@																		\					[820]
	;																			\					[0c2]


: brdctl!																		\ (83e)				[0b6 0b7]
	1d																			\					[010]
	mem-b!																		\					[821]
	;																			\					[0c2]


: seectl@																		\ (83f)				[0b6 0b7]
	1e																			\					[010]
	mem-b@																		\					[820]
	;																			\					[0c2]


: seectl!																		\ (840)				[0b6 0b7]
	1e																			\					[010]
	mem-b!																		\					[821]
	;																			\					[0c2]


: scratch@																		\ (841)				[0b6 0b7]
	20																			\					[010]
	+																			\					[01e]
	mem-b@																		\					[820]
	;																			\					[0c2]


: scratch!																		\ (842)				[0b6 0b7]
	20																			\					[010]
	+																			\					[01e]
	mem-b!																		\					[821]
	;																			\					[0c2]


: seq-ctl@																		\ (843)				[0b6 0b7]
	60																			\					[010]
	mem-b@																		\					[820]
	;																			\					[0c2]


: seq-ctl!																		\ (844)				[0b6 0b7]
	60																			\					[010]
	mem-b!																		\					[821]
	;																			\					[0c2]


: (seq-data@)																	\ (845)				[0b6 0b7]
	61																			\					[010]
	mem-b@																		\					[820]
	;																			\					[0c2]


: (seq-data!)																	\ (846)				[0b6 0b7]
	61																			\					[010]
	mem-b!																		\					[821]
	;																			\					[0c2]


: seq-data@																		\ (847)				[0b6 0b7]
	4																			\					[010]
	0																			\					[0a5]
	do																			\ (0x7)				[017]
		(seq-data@)																\					[845]
	loop																		\ (0xfffd)			[015]
	bljoin																		\					[07f]
	;																			\					[0c2]


: seq-data!																		\ (848)				[0b6 0b7]
	lbsplit																		\					[07e]
	>r																			\					[030]
	>r																			\					[030]
	>r																			\					[030]
	(seq-data!)																	\					[846]
	r>																			\					[031]
	(seq-data!)																	\					[846]
	r>																			\					[031]
	(seq-data!)																	\					[846]
	r>																			\					[031]
	(seq-data!)																	\					[846]
	;																			\					[0c2]


: seq-addr@																		\ (849)				[0b6 0b7]
	62																			\					[010]
	mem-b@																		\					[820]
	63																			\					[010]
	mem-b@																		\					[820]
	bwjoin																		\					[0b0]
	;																			\					[0c2]


: seq-addr!																		\ (84a)				[0b6 0b7]
	wbsplit																		\					[0af]
	3																			\					[010]
	and																			\					[023]
	swap																		\					[049]
	62																			\					[010]
	mem-b!																		\					[821]
	63																			\					[010]
	mem-b!																		\					[821]
	;																			\					[0c2]


: brkaddr!																		\ (84b)				[0b6 0b7]
	68																			\					[010]
	mem-b!																		\					[821]
	;																			\					[0c2]


: hcntrl@																		\ (84c)				[0b6 0b7]
	87																			\					[010]
	mem-b@																		\					[820]
	;																			\					[0c2]


: hcntrl!																		\ (84d)				[0b6 0b7]
	87																			\					[010]
	mem-b!																		\					[821]
	;																			\					[0c2]


: dscmd1@																		\ (84e)				[0b6 0b7]
	85																			\					[010]
	mem-b@																		\					[820]
	;																			\					[0c2]


: dscmd1!																		\ (84f)				[0b6 0b7]
	85																			\					[010]
	mem-b!																		\					[821]
	;																			\					[0c2]


: chip-reset																	\ (850)				[0b6 0b7]
	hcntrl@																		\					[84c]
	1																			\					[0a6]
	or																			\					[024]
	hcntrl!																		\					[84d]
	10																			\					[010]
	ms																			\					[126]
	begin																		\					[0b1]
		hcntrl@																	\					[84c]
		1																		\					[0a6]
		and																		\					[023]
	until																		\ (0xfffb)			[014]
	hcntrl@																		\					[84c]
	1																			\					[0a6]
	invert																		\					[026]
	and																			\					[023]
	hcntrl!																		\					[84d]
	;																			\					[0c2]


: haddr!																		\ (851)				[0b6 0b7]
	lbsplit																		\					[07e]
	0																			\					[0a5]
	dscmd1!																		\					[84f]
	3																			\					[0a8]
	roll																		\					[04f]
	88																			\					[010]
	mem-b!																		\					[821]
	rot																			\					[04a]
	89																			\					[010]
	mem-b!																		\					[821]
	swap																		\					[049]
	8a																			\					[010]
	mem-b!																		\					[821]
	8b																			\					[010]
	mem-b!																		\					[821]
	1																			\					[0a6]
	dscmd1!																		\					[84f]
	4																			\					[010]
	0																			\					[0a5]
	do																			\ (0xf)				[017]
		0																		\					[0a5]
		88																		\					[010]
		i																		\					[019]
		+																		\					[01e]
		mem-b!																	\					[821]
	loop																		\ (0xfff5)			[015]
	;																			\					[0c2]


: hcnt!																			\ (852)				[0b6 0b7]
	lbsplit																		\					[07e]
	drop																		\					[046]
	rot																			\					[04a]
	8c																			\					[010]
	mem-b!																		\					[821]
	swap																		\					[049]
	8d																			\					[010]
	mem-b!																		\					[821]
	8e																			\					[010]
	mem-b!																		\					[821]
	;																			\					[0c2]


: dfcntrl@																		\ (853)				[0b6 0b7]
	93																			\					[010]
	mem-b@																		\					[820]
	;																			\					[0c2]


: dfcntrl!																		\ (854)				[0b6 0b7]
	93																			\					[010]
	mem-b!																		\					[821]
	;																			\					[0c2]


: pci>df																		\ (855)				[0b6 0b7]
	dfcntrl@																	\					[853]
	4																			\					[010]
	or																			\					[024]
	dfcntrl!																	\					[854]
	;																			\					[0c2]


: df>pci																		\ (856)				[0b6 0b7]
	dfcntrl@																	\					[853]
	4																			\					[010]
	invert																		\					[026]
	and																			\					[023]
	dfcntrl!																	\					[854]
	;																			\					[0c2]


: enable-df																		\ (857)				[0b6 0b7]
	dfcntrl@																	\					[853]
	28																			\					[010]
	or																			\					[024]
	dfcntrl!																	\					[854]
	;																			\					[0c2]


: disable-df																	\ (858)				[0b6 0b7]
	dfcntrl@																	\					[853]
	28																			\					[010]
	invert																		\					[026]
	and																			\					[023]
	dfcntrl!																	\					[854]
	begin																		\					[0b1]
		dfcntrl@																\					[853]
		28																		\					[010]
		and																		\					[023]
		0=																		\					[034]
	until																		\ (0xfff6)			[014]
	;																			\					[0c2]


: scbptr@																		\ (859)				[0b6 0b7]
	90																			\					[010]
	mem-b@																		\					[820]
	;																			\					[0c2]


: scbptr!																		\ (85a)				[0b6 0b7]
	90																			\					[010]
	mem-b!																		\					[821]
	;																			\					[0c2]


: intstat@																		\ (85b)				[0b6 0b7]
	91																			\					[010]
	mem-b@																		\					[820]
	;																			\					[0c2]


: error@																		\ (85c)				[0b6 0b7]
	92																			\					[010]
	mem-b@																		\					[820]
	;																			\					[0c2]


: clrint!																		\ (85d)				[0b6 0b7]
	92																			\					[010]
	mem-b!																		\					[821]
	;																			\					[0c2]


: scbcnt@																		\ (85e)				[0b6 0b7]
	9a																			\					[010]
	mem-b@																		\					[820]
	;																			\					[0c2]


: scbcnt!																		\ (85f)				[0b6 0b7]
	9a																			\					[010]
	mem-b!																		\					[821]
	;																			\					[0c2]


: scbram@																		\ (860)				[0b6 0b7]
	0a0																			\					[010]
	+																			\					[01e]
	mem-b@																		\					[820]
	;																			\					[0c2]


: scbram!																		\ (861)				[0b6 0b7]
	0a0																			\					[010]
	+																			\					[01e]
	mem-b!																		\					[821]
	;																			\					[0c2]


: scb16@																		\ (862)				[0b6 0b7]
	10																			\					[010]
	scbram@																		\					[860]
	;																			\					[0c2]


: scb16!																		\ (863)				[0b6 0b7]
	10																			\					[010]
	scbram!																		\					[861]
	;																			\					[0c2]


: scb17@																		\ (864)				[0b6 0b7]
	11																			\					[010]
	scbram@																		\					[860]
	;																			\					[0c2]


: scb17!																		\ (865)				[0b6 0b7]
	11																			\					[010]
	scbram!																		\					[861]
	;																			\					[0c2]

0 value sg-list-v																\ (866 0)			[0a5 0b6 0b8]
0 value sg-list-p																\ (867 0)			[0a5 0b6 0b8]
20 constant /sg-list															\ (868 20)			[010 0b6 0ba]

: create-sg-list																\ (869)				[0b6 0b7]
	/sg-list																	\					[868]
	dma-alloc																	\					[818]
	to sg-list-v																\					[0c3 866]
	sg-list-v																	\					[866]
	/sg-list																	\					[868]
	get-phys-addr																\					[825]
	to sg-list-p																\					[0c3 867]
	;																			\					[0c2]


: free-sg-list																	\ (86a)				[0b6 0b7]
	sg-list-v																	\					[866]
	/sg-list																	\					[868]
	dma-free																	\					[819]
	0																			\					[0a5]
	to sg-list-v																\					[0c3 866]
	0																			\					[0a5]
	to sg-list-p																\					[0c3 867]
	;																			\					[0c2]


: >sg-list																		\ (86b)				[0b6 0b7]
	dup																			\					[047]
	lbsplit																		\					[07e]
	drop																		\					[046]
	sg-list-v																	\					[866]
	6																			\					[010]
	ca+																			\					[05e]
	c!																			\					[075]
	sg-list-v																	\					[866]
	5																			\					[010]
	ca+																			\					[05e]
	c!																			\					[075]
	sg-list-v																	\					[866]
	4																			\					[010]
	ca+																			\					[05e]
	c!																			\					[075]
	get-phys-addr																\					[825]
	lbsplit																		\					[07e]
	sg-list-v																	\					[866]
	3																			\					[0a8]
	ca+																			\					[05e]
	c!																			\					[075]
	sg-list-v																	\					[866]
	2																			\					[0a7]
	ca+																			\					[05e]
	c!																			\					[075]
	sg-list-v																	\					[866]
	char+																		\					[062]
	c!																			\					[075]
	sg-list-v																	\					[866]
	c!																			\					[075]
	;																			\					[0c2]

0 value cdb-adr																	\ (86c 0)			[0a5 0b6 0b8]
0 value cdb-len																	\ (86d 0)			[0a5 0b6 0b8]

: setup-cdb																		\ (86e)				[0b6 0b7]
	dup																			\					[047]
	dma-alloc																	\					[818]
	dup																			\					[047]
	to cdb-adr																	\					[0c3 86c]
	over																		\					[048]
	to cdb-len																	\					[0c3 86d]
	swap																		\					[049]
	move																		\					[078]
	;																			\					[0c2]


: free-cdb																		\ (86f)				[0b6 0b7]
	cdb-adr																		\					[86c]
	cdb-len																		\					[86d]
	dma-free																	\					[819]
	0																			\					[0a5]
	to cdb-adr																	\					[0c3 86c]
	0																			\					[0a5]
	to cdb-len																	\					[0c3 86d]
	;																			\					[0c2]

-1 instance value his-id														\ (870 -1)			[0a4 0c0 0b6 0b8]
-1 instance value his-lun														\ (871 -1)			[0a4 0c0 0b6 0b8]


external

: set-address																	\ (872)				[0ca 0b7]
	to his-id																	\					[0c3 870]
	to his-lun																	\					[0c3 871]
	;																			\					[0c2]


: set-my-id																		\ (873)				[0ca 0b7]
	scsi-id@																	\					[837]
	0f																			\					[010]
	and																			\					[023]
	or																			\					[024]
	scsi-id!																	\					[838]
	;																			\					[0c2]


headers

0 value scb																		\ (874 0)			[0a5 0b6 0b8]
20 constant /scb																\ (875 20)			[010 0b6 0ba]

: allocate-scb																	\ (876)				[0b6 0b7]
	/scb																		\					[875]
	dma-alloc																	\					[818]
	to scb																		\					[0c3 874]
	scb																			\					[874]
	/scb																		\					[875]
	erase																		\					[0a5 079]
	;																			\					[0c2]


: free-scb																		\ (877)				[0b6 0b7]
	scb																			\					[874]
	/scb																		\					[875]
	dma-free																	\					[819]
	0																			\					[0a5]
	to scb																		\					[0c3 874]
	;																			\					[0c2]


: setup-scb																		\ (878)				[0b6 0b7]
	setup-cdb																	\					[86e]
	drop																		\					[046]
	>sg-list																	\					[86b]
	allocate-scb																\					[876]
	sg-list-p																	\					[867]
	lbsplit																		\					[07e]
	scb																			\					[874]
	7																			\					[010]
	ca+																			\					[05e]
	c!																			\					[075]
	scb																			\					[874]
	6																			\					[010]
	ca+																			\					[05e]
	c!																			\					[075]
	scb																			\					[874]
	5																			\					[010]
	ca+																			\					[05e]
	c!																			\					[075]
	scb																			\					[874]
	4																			\					[010]
	ca+																			\					[05e]
	c!																			\					[075]
	1																			\					[0a6]
	scb																			\					[874]
	3																			\					[010]
	ca+																			\					[05e]
	c!																			\					[075]
	cdb-len																		\					[86d]
	scb																			\					[874]
	2																			\					[0a7]
	ca+																			\					[05e]
	c!																			\					[075]
	cdb-adr																		\					[86c]
	cdb-len																		\					[86d]
	get-phys-addr																\					[825]
	lbsplit																		\					[07e]
	scb																			\					[874]
	0b																			\					[010]
	ca+																			\					[05e]
	c!																			\					[075]
	scb																			\					[874]
	0a																			\					[010]
	ca+																			\					[05e]
	c!																			\					[075]
	scb																			\					[874]
	9																			\					[010]
	ca+																			\					[05e]
	c!																			\					[075]
	scb																			\					[874]
	8																			\					[010]
	ca+																			\					[05e]
	c!																			\					[075]
	his-id																		\					[870]
	4																			\					[010]
	lshift																		\					[027]
	his-lun																		\					[871]
	or																			\					[024]
	scb																			\					[874]
	c!																			\					[075]
	;																			\					[0c2]


: teardown-scb																	\ (879)				[0b6 0b7]
	free-cdb																	\					[86f]
	free-scb																	\					[877]
	;																			\					[0c2]

40 constant /nvram-size															\ (87a 40)			[010 0b6 0ba]
create nvram-buffer																\ (87b)				[0b6 0bb]
/nvram-size																		\					[87a]
allot																			\					[0a5 02f 0a5 018 0a5 0d0 015]
0 value nvram-type																\ (87c 0)			[0a5 0b6 0b8]
0 value nvram-valid																\ (87d 0)			[0a5 0b6 0b8]

: nvram@																		\ (87e)				[0b6 0b7]
	nvram-buffer																\					[87b]
	swap																		\					[049]
	ca+																			\					[05e]
	c@																			\					[071]
	;																			\					[0c2]


: nvram!																		\ (87f)				[0b6 0b7]
	nvram-buffer																\					[87b]
	swap																		\					[049]
	ca+																			\					[05e]
	c!																			\					[075]
	;																			\					[0c2]


: nvram-on																		\ (880)				[0b6 0b7]
	20																			\					[010]
	seectl!																		\					[840]
	begin																		\					[0b1]
		seectl@																	\					[83f]
		10																		\					[010]
		and																		\					[023]
	until																		\ (0xfff7)			[014]
	;																			\					[0c2]


: nvram-off																		\ (881)				[0b6 0b7]
	0																			\					[0a5]
	seectl!																		\					[840]
	;																			\					[0c2]


: get-nvram-type																\ (882)				[0b6 0b7]
	0																			\					[0a5]
	to nvram-type																\					[0c3 87c]
	789x?																		\					[806]
	if																			\ (0x19)			[014]
		subsysid@																\					[813]
		300																		\					[010]
		and																		\					[023]
		200																		\					[010]
		=																		\					[03c]
		if																		\ (0x7)				[014]
			1																	\					[0a6]
			to nvram-type														\					[0c3 87c]
		then																	\					[0b2]
	then																		\					[0b2]
	;																			\					[0c2]


: nvram-delay																	\ (883)				[0b6 0b7]
	3																			\					[0a8]
	0																			\					[0a5]
	do																			\ (0x14)			[017]
		begin																	\					[0b1]
			seectl@																\					[83f]
			10																	\					[010]
			and																	\					[023]
		until																	\ (0xfff7)			[014]
		dup																		\					[047]
		seectl!																	\					[840]
	loop																		\ (0xfff0)			[015]
	drop																		\					[046]
	;																			\					[0c2]


: nvram-send-start-bit															\ (884)				[0b6 0b7]
	2a																			\					[010]
	dup																			\					[047]
	seectl!																		\					[840]
	nvram-delay																	\					[883]
	2e																			\					[010]
	dup																			\					[047]
	seectl!																		\					[840]
	nvram-delay																	\					[883]
	2a																			\					[010]
	dup																			\					[047]
	seectl!																		\					[840]
	nvram-delay																	\					[883]
	;																			\					[0c2]


: nvram-send-address															\ (885)				[0b6 0b7]
	1																			\					[0a6]
	swap																		\					[049]
	1-																			\					[0a6 01f]
	lshift																		\					[027]
	begin																		\					[0b1]
		2dup																	\					[053]
		and																		\					[023]
		if																		\ (0xb)				[014]
			2a																	\					[010]
		else																	\ (0x9)				[013 0b2]
			28																	\					[010]
		then																	\					[0b2]
		dup																		\					[047]
		dup																		\					[047]
		seectl!																	\					[840]
		nvram-delay																\					[883]
		4																		\					[010]
		or																		\					[024]
		dup																		\					[047]
		seectl!																	\					[840]
		nvram-delay																\					[883]
		2/																		\					[057]
		dup																		\					[047]
		0=																		\					[034]
	until																		\ (0xffd7)			[014]
	2drop																		\					[052]
	;																			\					[0c2]


: nvram-read-register															\ (886)				[0b6 0b7]
	nvram-type																	\					[87c]
	if																			\ (0x11)			[014]
		200																		\					[010]
		or																		\					[024]
		0a																		\					[010]
	else																		\ (0xf)				[013 0b2]
		80																		\					[010]
		or																		\					[024]
		8																		\					[010]
	then																		\					[0b2]
	nvram-send-start-bit														\					[884]
	nvram-send-address															\					[885]
	28																			\					[010]
	dup																			\					[047]
	seectl!																		\					[840]
	nvram-delay																	\					[883]
	0																			\					[0a5]
	10																			\					[010]
	0																			\					[0a5]
	do																			\ (0x27)			[017]
		2*																		\					[059]
		2c																		\					[010]
		dup																		\					[047]
		seectl!																	\					[840]
		nvram-delay																\					[883]
		28																		\					[010]
		seectl!																	\					[840]
		seectl@																	\					[83f]
		1																		\					[010]
		and																		\					[023]
		or																		\					[024]
		28																		\					[010]
		nvram-delay																\					[883]
	loop																		\ (0xffdd)			[015]
	20																			\					[010]
	dup																			\					[047]
	seectl!																		\					[840]
	nvram-delay																	\					[883]
	;																			\					[0c2]


: read-nvram																	\ (887)				[0b6 0b7]
	nvram-on																	\					[880]
	get-nvram-type																\					[882]
	/nvram-size																	\					[87a]
	2/																			\					[057]
	0																			\					[0a5]
	do																			\ (0x13)			[017]
		i																		\					[019]
		nvram-read-register														\					[886]
		wbsplit																	\					[0af]
		i																		\					[019]
		2*																		\					[059]
		dup																		\					[047]
		1+																		\					[0a6 01e]
		-rot																	\					[04b]
		nvram!																	\					[87f]
		nvram!																	\					[87f]
	loop																		\ (0xfff1)			[015]
	nvram-off																	\					[881]
	nvram-buffer																\					[87b]
	/nvram-size																	\					[87a]
	encode-bytes																\					[115]
	" ADPT,nvram"																\					[012]
	property																	\					[110]
	0																			\					[0a5]
	/nvram-size																	\					[87a]
	0																			\					[0a5]
	do																			\ (0x9)				[017]
		i																		\					[019]
		nvram@																	\					[87e]
		+																		\					[01e]
	loop																		\ (0xfffb)			[015]
	dup																			\					[047]
	0=																			\					[034]
	swap																		\					[049]
	3fc0																		\					[010]
	=																			\					[03c]
	or																			\					[024]
	if																			\ (0x1a)			[014]
		0																		\					[0a5]
		to nvram-valid															\					[0c3 87d]
		" NVRAM is blank"														\					[012]
		warning																	\					[80c]
		exit																	\					[033]
	then																		\					[0b2]
	27																			\					[010]
	nvram@																		\					[87e]
	#targets																	\					[808]
	<>																			\					[03d]
	if																			\ (0x24)			[014]
		0																		\					[0a5]
		to nvram-valid															\					[0c3 87d]
		" NVRAM target count wrong"												\					[012]
		warning																	\					[80c]
		exit																	\					[033]
	then																		\					[0b2]
	0																			\					[0a5]
	/nvram-size																	\					[87a]
	2/																			\					[057]
	1-																			\					[0a6 01f]
	0																			\					[0a5]
	do																			\ (0x11)			[017]
		i																		\					[019]
		2*																		\					[059]
		dup																		\					[047]
		1+																		\					[0a6 01e]
		nvram@																	\					[87e]
		swap																	\					[049]
		nvram@																	\					[87e]
		bwjoin																	\					[0b0]
		+																		\					[01e]
	loop																		\ (0xfff3)			[015]
	0ffff																		\					[010]
	and																			\					[023]
	3f																			\					[010]
	nvram@																		\					[87e]
	3e																			\					[010]
	nvram@																		\					[87e]
	bwjoin																		\					[0b0]
	<>																			\					[03d]
	if																			\ (0x20)			[014]
		0																		\					[0a5]
		to nvram-valid															\					[0c3 87d]
		" NVRAM checksum error"													\					[012]
		warning																	\					[80c]
		exit																	\					[033]
	then																		\					[0b2]
	1																			\					[0a6]
	to nvram-valid																\					[0c3 87d]
	;																			\					[0c2]


: nvram-get-host-id																\ (888)				[0b6 0b7]
	nvram-valid																	\					[87d]
	if																			\ (0x13)			[014]
		25																		\					[010]
		nvram@																	\					[87e]
		0f																		\					[010]
		and																		\					[023]
	else																		\ (0x9)				[013 0b2]
		7																		\					[010]
	then																		\					[0b2]
	;																			\					[0c2]


: nvram-get-termination															\ (889)				[0b6 0b7]
	nvram-valid																	\					[87d]
	0=																			\					[034]
	if																			\ (0x5)				[014]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	23																			\					[010]
	nvram@																		\					[87e]
	dup																			\					[047]
	1																			\					[010]
	and																			\					[023]
	if																			\ (0xb)				[014]
		3																		\					[010]
	else																		\ (0x31)			[013 0b2]
		dup																		\					[047]
		4																		\					[010]
		and																		\					[023]
		if																		\ (0xb)				[014]
			0																	\					[010]
		else																	\ (0x1d)			[013 0b2]
			dup																	\					[047]
			8																	\					[010]
			and																	\					[023]
			if																	\ (0xb)				[014]
				2																\					[010]
			else																\ (0x9)				[013 0b2]
				1																\					[010]
			then																\					[0b2]
		then																	\					[0b2]
	then																		\					[0b2]
	nip																			\					[04d]
	789x?																		\					[806]
	if																			\ (0x59)			[014]
		subsysid@																\					[813]
		80																		\					[010]
		and																		\					[023]
		if																		\ (0x4b)			[014]
			22																	\					[010]
			nvram@																\					[87e]
			dup																	\					[047]
			4																	\					[010]
			and																	\					[023]
			if																	\ (0xb)				[014]
				30																\					[010]
			else																\ (0x31)			[013 0b2]
				dup																\					[047]
				8																\					[010]
				and																\					[023]
				if																\ (0xb)				[014]
					0															\					[010]
				else															\ (0x1d)			[013 0b2]
					dup															\					[047]
					10															\					[010]
					and															\					[023]
					if															\ (0xb)				[014]
						20														\					[010]
					else														\ (0x9)				[013 0b2]
						10														\					[010]
					then														\					[0b2]
				then															\					[0b2]
			then																\					[0b2]
		then																	\					[0b2]
		nip																		\					[04d]
		or																		\					[024]
	then																		\					[0b2]
	;																			\					[0c2]


: qinfifo@																		\ (88a)				[0b6 0b7]
	9b																			\					[010]
	mem-b@																		\					[820]
	;																			\					[0c2]


: qinfifo!																		\ (88b)				[0b6 0b7]
	9b																			\					[010]
	mem-b!																		\					[821]
	;																			\					[0c2]


: pause																			\ (88c)				[0b6 0b7]
	hcntrl@																		\					[84c]
	4																			\					[010]
	or																			\					[024]
	hcntrl!																		\					[84d]
	begin																		\					[0b1]
		hcntrl@																	\					[84c]
		4																		\					[010]
		and																		\					[023]
	until																		\ (0xfff7)			[014]
	;																			\					[0c2]


: unpause																		\ (88d)				[0b6 0b7]
	hcntrl@																		\					[84c]
	4																			\					[010]
	invert																		\					[026]
	and																			\					[023]
	hcntrl!																		\					[84d]
	;																			\					[0c2]


: clear-scratch																	\ (88e)				[0b6 0b7]
	40																			\					[010]
	0																			\					[0a5]
	do																			\ (0x9)				[017]
		0																		\					[0a5]
		i																		\					[019]
		scratch!																\					[842]
	loop																		\ (0xfffb)			[015]
	;																			\					[0c2]


: cmd-cntrl@																	\ (88f)				[0b6 0b7]
	3e																			\					[010]
	scratch@																	\					[841]
	;																			\					[0c2]


: cmd-cntrl!																	\ (890)				[0b6 0b7]
	3e																			\					[010]
	scratch!																	\					[842]
	;																			\					[0c2]


: set-break																		\ (891)				[0b6 0b7]
	cmd-cntrl@																	\					[88f]
	4																			\					[010]
	or																			\					[024]
	cmd-cntrl!																	\					[890]
	;																			\					[0c2]


: set-qin																		\ (892)				[0b6 0b7]
	cmd-cntrl@																	\					[88f]
	2																			\					[0a7]
	or																			\					[024]
	cmd-cntrl!																	\					[890]
	;																			\					[0c2]


: clear-scbs																	\ (893)				[0b6 0b7]
	3																			\					[0a8]
	0																			\					[0a5]
	do																			\ (0x18)			[017]
		i																		\					[019]
		scbptr!																	\					[85a]
		20																		\					[010]
		0																		\					[0a5]
		do																		\ (0x9)				[017]
			0																	\					[0a5]
			i																	\					[019]
			scbram!																\					[861]
		loop																	\ (0xfffb)			[015]
	loop																		\ (0xffec)			[015]
	0																			\					[0a5]
	scbptr!																		\					[85a]
	;																			\					[0c2]


: $c,																			\ (894)				[0b6 0b7]
	bounds																		\					[0ac]
	?do																			\ (0x8)				[018]
		i																		\					[019]
		c@																		\					[071]
		c,																		\					[0d0]
	loop																		\ (0xfffc)			[015]
	;																			\					[0c2]

create sequencer-code															\ (895)				[0b6 0bb]
" "(0065 0EC0 0065 80C0 0065 9C40 0065 CA40 0065 9842 5A6A 0080 F711 2288 006A 2009)" \ ".e..e.e@.e@.eBZj..".j ."	\					[012]
$c,																				\					[894]
" "(013B 78B0 400B 7468 200B 2CE8 4000 00E8 C05E 2278 025E 2A78 006A 2009 FD5E BC88)" \ ".;x@.th .,@..^"x.^*x.j .^"	\					[012]
$c,																				\					[894]
" "(0065 26C0 019C 2AF8 019B 20B1 0190 7830 0065 6040 0065 0040 FF6A 7880 086A 1800)" \ ".e&.*. .x0.e`@.e.@.jx.j.."	\					[012]
$c,																				\					[894]
" "(0811 2200 200B 0CF8 206A 1680 0065 74DA E064 40F0 A064 88E2 216A 2201 0065 3640)" \ "..". .. j..etd@d!j"..e6@"	\					[012]
$c,																				\					[894]
" "(8012 0E7A 0F12 C888 0019 7400 01A0 C8B0 006A 6888 0134 78B0 FBA1 4289 003A FCD9)" \ "..z..Ȉ..t..Ȱ.jh.4xB.:"	\					[012]
$c,																				\					[894]
" "(0065 72DA E064 5670 0065 58C0 8012 50E8 FFA2 5CE8 016A 4481 FFB7 9CF8 01B7 0071)" \ ".erdVp.eX.P.\.jD...q"	\					[012]
$c,																				\					[894]
" "(013C 76B0 F0A0 C888 405E AAEA 0F05 0A08 0005 0A80 006A 2609 1801 0280 206A 1800)" \ ".<vȈ@^........j&.... j.."	\					[012]
$c,																				\					[894]
" "(5A6A 0080 400B 00F8 01A3 66B1 086A 1800 126A 0080 0811 2200 400B 0AF8 406A 1680)" \ "Zj.@...f.j...j...".@..@j."	\					[012]
$c,																				\					[894]
" "(0065 74DA 405E 3EEB A064 AC60 0FA0 7208 40A1 90F8 326A F4D9 006E 90E8 4039 7200)" \ ".et@^>d`.r.@2j.n@9r."	\					[012]
$c,																				\					[894]
" "(8039 7400 013A 7230 00A0 FE59 8F3A 9AF0 406A 1800 0139 0C30 0065 74DA 8064 B270)" \ "9t..:r0.Y:@j...9.0.etڀdp"	\					[012]
$c,																				\					[894]
" "(E064 A8F0 C064 52F1 A064 88E2 016A 2281 006A A6D9 0065 9C40 406A 1800 C064 52F1)" \ "ddRd.j".j.e@@j..dR"	\					[012]
$c,																				\					[894]
" "(8064 8862 406A 1800 00A0 FCD9 8F3A A6F0 01A2 72B0 A86A A2DA 405E C0EA 01A2 1030)" \ "db@j...ُ:.rj@^..0"	\					[012]
$c,																				\					[894]
" "(3D6A 2601 040B D0E8 100C C2F8 040B D0E8 006A 2609 0065 74DA C064 52F1 116A 2201)" \ "=j&........j&..etdR.j"."	\					[012]
$c,																				\					[894]
" "(405E EC6A 346A CC00 A36A 12DA 0065 24DA B86A CC80 886A 105A 01A1 C830 0164 6C31)" \ "@^j4j.j..e$ڸj̀j.Z.0.dl1"	\					[012]
$c,																				\					[894]
" "(A36A CC80 346A 125A 0065 12C1 0493 EC68 405E F86A 0194 EA78 1094 ECE8 C793 2689)" \ "j̀4j.Z.e..h@^j.x.Ǔ&"	\					[012]
$c,																				\					[894]
" "(C05E F468 0199 D430 0893 F0E8 B06A CC00 086A 16DA 0134 6631 405E 0A6B 0065 7EDA)" \ "^h.0.j..j..4f1@^.k.e~"	\					[012]
$c,																				\					[894]
" "(346A CC00 A36A 12DA 886A CC80 B86A 105A 405E 12E9 086A CC00 8C6A 16DA 01B6 C830)" \ "4j.j.ڈj̀j.Z@^..j.j..0"	\					[012]
$c,																				\					[894]
" "(0164 4231 FFBC 1AE9 FFBD 1A69 FFBE 1A69 FFA3 4CF9 0065 7EDA 405E 186B 396A 7280)" \ ".dB1....i..i.L.e~@^.k9jr"	\					[012]
$c,																				\					[894]
" "(4003 2469 3D6A 7200 BF39 7288 10A1 2A69 FF34 2C79 4039 7200 0139 2631 006A 4489)" \ "@.$i=jr.9r.*i.4,y@9r..9&1.jD"	\					[012]
$c,																				\					[894]
" "(100C E668 010B 3079 8004 3A79 010C 36F9 100C EEE8 10A1 3E69 FF34 4679 0065 24DA)" \ "..h..0y.:y..6...>i.4Fy.e$"	\					[012]
$c,																				\					[894]
" "(0065 24C1 016A A659 0065 00C1 B06A CC00 0065 1EDA C793 2689 0065 7EDA 316A 2281)" \ ".e$.jY.e.j..e.Ǔ&.e~1j""	\					[012]
$c,																				\					[894]
" "(0065 4C41 FFB0 7469 FFB1 74E9 FFB2 74E9 FFB3 7469 0106 7430 0065 74DA E064 8862)" \ ".eLA.ti.t.t.ti..t0.etdb"	\					[012]
$c,																				\					[894]
" "(FF12 64F9 416A 2201 FF3A 1C6A 0065 8A5A C05E 6EE9 0190 3AB1 0065 7041 015E BC00)" \ "..dAj"..:.j.eZ^n.:.epA.^."	\					[012]
$c,																				\					[894]
" "(026A 2281 0065 0040 346A CC00 A36A 12DA 0134 C830 0164 C818 00B3 84E1 006A 6689)" \ ".j".e.@4j.j..40.d...jf"	\					[012]
$c,																				\					[894]
" "(0065 90C1 0065 24DA 0134 C830 00B3 82E1 006A 6689 10A1 8EE9 FF34 A279 0065 24DA)" \ ".e.e$.40..jf..4y.e$"	\					[012]
$c,																				\					[894]
" "(0108 C830 00B0 6099 0109 C8B0 00B1 6221 010A C8B0 00B2 6421 01B3 C830 006A 66A1)" \ "..0.`..Ȱ.b!..Ȱ.d!.0.jf"	\					[012]
$c,																				\					[894]
" "(0065 8A41 316A 2281 0065 5AC1 0165 6E31 0212 B471 0412 CA71 0112 D6F1 0312 EEF1)" \ ".eA1j".eZ.en1..q..q...."	\					[012]
$c,																				\					[894]
" "(0812 ECF1 416A 2285 FFA2 C4E9 A36A CC80 346A 125A B86A CC80 146A 14DA B06A 16DA)" \ "..Aj".j̀4j.Zj̀.j.ڰj."	\					[012]
$c,																				\					[894]
" "(01A1 C830 0164 6C31 0106 D430 405E FEE8 0065 1A41 40A1 B279 326A F4D9 006E B269)" \ ".0.dl1..0@^.e.A@y2j.ni"	\					[012]
$c,																				\					[894]
" "(04A1 4201 0065 8A5A 0065 0040 0065 72DA E064 9662 0112 7430 0065 72DA E064 9662)" \ ".B..eZ.e.@.erdb..t0.erdb"	\					[012]
$c,																				\					[894]
" "(053A E861 FF12 E8E9 416A 2201 0065 C441 716A 2201 FF6A D420 0106 D4B4 0065 72DA)" \ ".:a..Aj"..eAqj"..j ..Դ.er"	\					[012]
$c,																				\					[894]
" "(8064 B270 FF6A D48C 80A0 F879 0165 CA18 01A0 DCB0 016C C834 1A01 0200 405E B06A)" \ "dp.jԌy.e..ܰ.l4....@^j"	\					[012]
$c,																				\					[894]
" "(4C65 CA28 2065 CA18 016C 7430 306A F459 006E 0CFA 2001 0200 013A 0834 916A 2281)" \ "Le( e..lt00jY.n. ....:.4j""	\					[012]
$c,																				\					[894]
" "(0065 18DA 016C DAB0 016C DAB0 016C DAB0 016C DAB0 016C DA34 516A 2281 0065 205A)" \ ".e..lڰ.lڰ.lڰ.lڰ.l4Qj".e Z"	\					[012]
$c,																				\					[894]
" "(006A DA88 006A DA0C 405E C6EA C793 2689 3893 286A 10A1 38FA EFA1 4289 886A CC80)" \ ".jڈ.j.@^Ǔ&8(j.8Bj̀"	\					[012]
$c,																				\					[894]
" "(886A 14DA 046A DA80 0065 205A 0065 6E42 886A CC80 356A 14DA 086A DA80 0065 205A)" \ "j..jڀ.e Z.enBj̀5j..jڀ.e Z"	\					[012]
$c,																				\					[894]
" "(0D93 2601 0894 427A F793 2689 356A CC80 886A 14DA FF34 6898 886A CC80 0199 DAB0)" \ ".&..Bz&5j̀j..4hj̀.ڰ"	\					[012]
$c,																				\					[894]
" "(8F66 4EE2 018C C830 0088 7498 033A 6EFA 043A 6E7A 083A 6E7A FF8E 66EA FF8D 66EA)" \ "fN.0.t.:n.:nz.:nz.f.f"	\					[012]
$c,																				\					[894]
" "(F36A C800 008C 7418 0065 6ED2 FC8C 1899 FF8D 1A21 FF8E 1C21 10A1 4201 086A CC00)" \ "j..t..en...!..!.B..j."	\					[012]
$c,																				\					[894]
" "(8C6A 16C2 0106 D430 010C 74FA 040C 746A E003 0688 E003 C88C 216A 2201 0065 74DA)" \ "j...0..t..tj...Ȍ!j"..et"	\					[012]
$c,																				\					[894]
" "(A064 96FA E064 42F1 C064 52F1 A064 7CF2 616A 2281 006A 0888 DF01 0288 F711 2288)" \ "ddBdRd|aj".j....""	\					[012]
$c,																				\					[894]
" "(0106 D430 090C 92FA 080C 88FA FF6A D48C FFB0 6099 FFB0 98EA FFB1 6299 FFB1 98E2)" \ "..0.....jԌ.`..b."	\					[012]
$c,																				\					[894]
" "(016A 2281 886A CC80 0065 14DA 0139 DAB0 0065 2042 0F0F 1E08 000F 1E80 0065 6A40)" \ ".j"j̀.e..9ڰ.e B........ej@"	\					[012]
$c,																				\					[894]
" "(4C65 CA28 0165 C8B0 2065 CA18 016C 7430 013A 08B0 0164 CAB0 7065 CA18 016C 0AB4)" \ "Le(.eȰ e..lt0.:..dʰpe..l."	\					[012]
$c,																				\					[894]
" "(026A F801 AC6A 2681 0065 C2C0 D793 2609 2893 C86A 0065 74DA E003 C808 C064 D662)" \ ".j.j&.eד&.(j.et..db"	\					[012]
$c,																				\					[894]
" "(0065 DC5A 04EA D419 03E9 1034 0065 DC5A 07E9 10B1 FF6A D48C 0435 C0B1 086A D001)" \ ".eZ....4.eZ...jԌ.5.j."	\					[012]
$c,																				\					[894]
" "(006A DE89 096A D681 80EB E4FA 016A D601 04E0 6AB0 FF34 681C 05A3 6830 0065 C6DA)" \ ".jމ.jց.j..j.4h..h0.e"	\					[012]
$c,																				\					[894]
" "(006A D489 07E9 70B1 0534 4631 0065 12C1 DF93 2689 2093 FA6A 0293 2601 0194 FC7A)" \ ".jԉ.p.4F1.e.ߓ& j.&..z"	\					[012]
$c,																				\					[894]
" "(0194 FC7A 0194 FC7A 0194 FC7A 0194 FC7A 0065 ECC0 1201 0280 040C 10FB 0065 7EDA)" \ ".z.z.z.z.e.......e~"	\					[012]
$c,																				\					[894]
" "(E003 C808 E003 0688 0065 805A 0065 00C1 A86A 7200 4003 1EEB AC6A 7280 006A F809)" \ ".....eZ.e.jr.@..jr.j."	\					[012]
$c,																				\					[894]
" "(FF34 24EB 026A F801 0139 2631 006A 4489 100C E668 010B 28FB FF34 4679 8004 347B)" \ ".4$.j..9&1.jD..h..(.4Fy.4{"	\					[012]
$c,																				\					[894]
" "(010C 307B 100C EEE8 0065 D65A 0065 1E43 046C C0B1 0139 D031 006A DE0D 045E 84F8)" \ "..0{...eZ.e.C.l.91.j..^"	\					[012]
$c,																				\					[894]
" "(B16A 2201 0065 8440)" \ "j"..e@"											\					[012]
$c,																				\					[894]
here																			\					[0ad]
sequencer-code																	\					[895]
-																				\					[01f]
constant /sequencer-code														\ (896)				[0b6 0ba]

: init-sequencer																\ (897)				[0b6 0b7]
	81																			\					[010]
	seq-ctl!																	\					[844]
	;																			\					[0c2]


: reset-sequencer																\ (898)				[0b6 0b7]
	80																			\					[010]
	seq-ctl!																	\					[844]
	;																			\					[0c2]


: (code@)																		\ (899)				[0b6 0b7]
	>r																			\					[030]
	r@																			\					[032]
	c@																			\					[071]
	r@																			\					[032]
	1+																			\					[0a6 01e]
	c@																			\					[071]
	r@																			\					[032]
	2+																			\					[0a7 01e]
	c@																			\					[071]
	r>																			\					[031]
	3																			\					[0a8]
	+																			\					[01e]
	c@																			\					[071]
	bljoin																		\					[07f]
	;																			\					[0c2]

defer code@																		\ (89a)				[0b6 0bc]
['] (code@)																		\					[011 899]
to code@																		\					[0c3 89a]

: load-sequencer																\ (89b)				[0b6 0b7]
	0																			\					[0a5]
	seq-addr!																	\					[84a]
	sequencer-code																\					[895]
	/sequencer-code																\					[896]
	bounds																		\					[0ac]
	do																			\ (0xf)				[017]
		i																		\					[019]
		code@																	\					[89a]
		seq-data!																\					[848]
		4																		\					[010]
	+loop																		\ (0xfff5)			[016]
	;																			\					[0c2]


: verify-sequencer																\ (89c)				[0b6 0b7]
	0																			\					[0a5]
	seq-addr!																	\					[84a]
	sequencer-code																\					[895]
	/sequencer-code																\					[896]
	bounds																		\					[0ac]
	do																			\ (0x26)			[017]
		i																		\					[019]
		code@																	\					[89a]
		seq-data@																\					[847]
		<>																		\					[03d]
		if																		\ (0x15)			[014]
			debug?																\					[80a]
			if																	\ (0xc)				[014]
				cr																\					[092]
				i																\					[019]
				sequencer-code													\					[895]
				-																\					[01f]
				u.																\					[09b]
				seq-addr@														\					[849]
				u.																\					[09b]
			then																\					[0b2]
			unloop																\					[089]
			-1																	\					[0a4]
			exit																\					[033]
		then																	\					[0b2]
		4																		\					[010]
	+loop																		\ (0xffde)			[016]
	0																			\					[0a5]
	;																			\					[0c2]


: download-sequencer															\ (89d)				[0b6 0b7]
	init-sequencer																\					[897]
	load-sequencer																\					[89b]
	reset-sequencer																\					[898]
	init-sequencer																\					[897]
	verify-sequencer															\					[89c]
	reset-sequencer																\					[898]
	;																			\					[0c2]


: 60-code@																		\ (89e)				[0b6 0b7]
	(code@)																		\					[899]
	>r																			\					[030]
	r@																			\					[032]
	0ffff																		\					[010]
	and																			\					[023]
	r@																			\					[032]
	3fe0000																		\					[010]
	and																			\					[023]
	1																			\					[0a6]
	rshift																		\					[028]
	r@																			\					[032]
	78000000																	\					[010]
	and																			\					[023]
	dup																			\					[047]
	1b																			\					[010]
	rshift																		\					[028]
	8																			\					[010]
	<																			\					[03a]
	if																			\ (0x36)			[014]
		r@																		\					[032]
		4000000																	\					[010]
		and																		\					[023]
		2																		\					[0a7]
		rshift																	\					[028]
		rot																		\					[04a]
		0feffffff																\					[010]
		and																		\					[023]
		or																		\					[024]
		swap																	\					[049]
		dup																		\					[047]
		1b																		\					[010]
		rshift																	\					[028]
		6																		\					[010]
		=																		\					[03c]
		if																		\ (0x13)			[014]
			drop																\					[046]
			1																	\					[0a6]
			1b																	\					[010]
			lshift																\					[027]
			rot																	\					[04a]
			0ff																	\					[010]
			or																	\					[024]
			-rot																\					[04b]
		then																	\					[0b2]
	then																		\					[0b2]
	2																			\					[0a7]
	rshift																		\					[028]
	or																			\					[024]
	or																			\					[024]
	r>																			\					[031]
	drop																		\					[046]
	;																			\					[0c2]

['] 60-code@																	\					[011 89e]
to code@																		\					[0c3 89a]

: send-scb																		\ (89f)				[0b6 0b7]
	scbptr@																		\					[859]
	0																			\					[0a5]
	scbcnt!																		\					[85f]
	0																			\					[0a5]
	scbptr!																		\					[85a]
	80																			\					[010]
	scbcnt!																		\					[85f]
	/scb																		\					[875]
	0																			\					[0a5]
	do																			\ (0xd)				[017]
		scb																		\					[874]
		i																		\					[019]
		+																		\					[01e]
		c@																		\					[071]
		0																		\					[0a5]
		scbram!																	\					[861]
	loop																		\ (0xfff7)			[015]
	0																			\					[0a5]
	scbcnt!																		\					[85f]
	0																			\					[0a5]
	qinfifo!																	\					[88b]
	scbptr!																		\					[85a]
	;																			\					[0c2]


: cable-sense																	\ (8a0)				[0b6 0b7]
	seectl@																		\					[83f]
	20																			\					[010]
	seectl!																		\					[840]
	brdctl@																		\					[83d]
	0c																			\					[010]
	or																			\					[024]
	1																			\					[0a6]
	ms																			\					[126]
	brdctl!																		\					[83e]
	seectl@																		\					[83f]
	dup																			\					[047]
	20																			\					[010]
	or																			\					[024]
	seectl!																		\					[840]
	1																			\					[0a6]
	ms																			\					[126]
	20																			\					[010]
	invert																		\					[026]
	and																			\					[023]
	seectl!																		\					[840]
	brdctl@																		\					[83d]
	60																			\					[010]
	and																			\					[023]
	60																			\					[010]
	=																			\					[03c]
	if																			\ (0x7)				[014]
		1																		\					[0a6]
	else																		\ (0x5)				[013 0b2]
		0																		\					[0a5]
	then																		\					[0b2]
	swap																		\					[049]
	seectl!																		\					[840]
	;																			\					[0c2]


: select-termination															\ (8a1)				[0b6 0b7]
	0f																			\					[010]
	and																			\					[023]
	dup																			\					[047]
	3																			\					[0a8]
	=																			\					[03c]
	if																			\ (0x6)				[014]
		drop																	\					[046]
		cable-sense																\					[8a0]
	then																		\					[0b2]
	1																			\					[0a6]
	=																			\					[03c]
	if																			\ (0xd)				[014]
		sxfrctl1@																\					[82c]
		1																		\					[0a6]
		invert																	\					[026]
		and																		\					[023]
		sxfrctl1!																\					[82d]
	else																		\ (0xa)				[013 0b2]
		sxfrctl1@																\					[82c]
		1																		\					[0a6]
		or																		\					[024]
		sxfrctl1!																\					[82d]
	then																		\					[0b2]
	;																			\					[0c2]

0 value scb16																	\ (8a2 0)			[0a5 0b6 0b8]
0 value scb17																	\ (8a3 0)			[0a5 0b6 0b8]
0 value simode																	\ (8a4 0)			[0a5 0b6 0b8]

: reset-bus																		\ (8a5)				[0b6 0b7]
	scb16@																		\					[862]
	to scb16																	\					[0c3 8a2]
	scb17@																		\					[864]
	to scb17																	\					[0c3 8a3]
	0ff																			\					[010]
	scb16!																		\					[863]
	0																			\					[010]
	scb17!																		\					[865]
	4																			\					[010]
	seq-addr!																	\					[84a]
	simode0@																	\					[839]
	to simode																	\					[0c3 8a4]
	0																			\					[0a5]
	simode0!																	\					[83a]
	0																			\					[0a5]
	simode1!																	\					[83c]
	0f																			\					[010]
	clrint!																		\					[85d]
	1																			\					[010]
	scsiseq!																	\					[829]
	0f																			\					[010]
	clrint!																		\					[85d]
	1																			\					[0a6]
	ms																			\					[126]
	0																			\					[0a5]
	scsiseq!																	\					[829]
	20																			\					[010]
	scsi-int1!																	\					[832]
	scsi-stat1@																	\					[833]
	0ff																			\					[010]
	scsi-int0!																	\					[830]
	10																			\					[010]
	invert																		\					[026]
	and																			\					[023]
	scsi-int1!																	\					[832]
	5																			\					[010]
	clrint!																		\					[85d]
	40																			\					[010]
	ms																			\					[126]
	simode																		\					[8a4]
	simode0!																	\					[83a]
	0a4																			\					[010]
	simode1!																	\					[83c]
	scb16																		\					[8a2]
	scb16!																		\					[863]
	scb17																		\					[8a3]
	scb17!																		\					[865]
	0																			\					[0a5]
	seq-addr!																	\					[84a]
	;																			\					[0c2]


: reset-channel																	\ (8a6)				[0b6 0b7]
	0																			\					[0a5]
	scsiseq!																	\					[829]
	0ff																			\					[010]
	scsi-int0!																	\					[830]
	0ff																			\					[010]
	scsi-int1!																	\					[832]
	12																			\					[010]
	sxfrctl0!																	\					[82b]
	27																			\					[010]
	sxfrctl1!																	\					[82d]
	begin																		\					[0b1]
		dfcntrl@																\					[853]
		8																		\					[010]
		and																		\					[023]
		while																	\ (0xd)				[014]
			0																	\					[010]
			dfcntrl!															\					[854]
	repeat																		\ (0xffed)			[013 0b2]
	1																			\					[010]
	dfcntrl!																	\					[854]
	0a4																			\					[010]
	simode1!																	\					[83c]
	789x?																		\					[806]
	if																			\ (0xa)				[014]
		8																		\					[010]
		simode0!																\					[83a]
	then																		\					[0b2]
	0																			\					[010]
	scbptr!																		\					[85a]
	;																			\					[0c2]


: wait-for-int																	\ (8a7)				[0b6 0b7]
	begin																		\					[0b1]
		intstat@																\					[85b]
		0f																		\					[010]
		and																		\					[023]
	until																		\ (0xfff7)			[014]
	;																			\					[0c2]

0 value hw-status																\ (8a8 0)			[0a5 0b6 0b8]
0 value hw-error																\ (8a9 0)			[0a5 0b6 0b8]

: handle-command-complete														\ (8aa)				[0b6 0b7]
	789x?																		\					[806]
	if																			\ (0x29)			[014]
		cmd-cntrl@																\					[88f]
		1																		\					[010]
		and																		\					[023]
		if																		\ (0x1a)			[014]
			cmd-cntrl@															\					[88f]
			0fe																	\					[010]
			and																	\					[023]
			cmd-cntrl!															\					[890]
			2																	\					[0a7]
			clrint!																\					[85d]
			0c																	\					[010]
			scbram@																\					[860]
			to hw-status														\					[0c3 8a8]
		then																	\					[0b2]
	else																		\ (0x11)			[013 0b2]
		2																		\					[0a7]
		clrint!																	\					[85d]
		0c																		\					[010]
		scbram@																	\					[860]
		to hw-status															\					[0c3 8a8]
	then																		\					[0b2]
	;																			\					[0c2]


: handle-scsi-ints																\ (8ab)				[0b6 0b7]
	scsi-stat0@																	\					[831]
	8																			\					[010]
	and																			\					[023]
	if																			\ (0x13)			[014]
		8																		\					[010]
		0b																		\					[010]
		mem-b!																	\					[821]
		reset-bus																\					[8a5]
		reset-channel															\					[8a6]
	then																		\					[0b2]
	scsi-stat1@																	\					[833]
	80																			\					[010]
	and																			\					[023]
	if																			\ (0x1c)			[014]
		scsiseq@																\					[828]
		48																		\					[010]
		invert																	\					[026]
		and																		\					[023]
		scsiseq!																\					[829]
		88																		\					[010]
		scsi-int1!																\					[832]
		10																		\					[010]
		scsi-int0!																\					[830]
	then																		\					[0b2]
	scsi-stat1@																	\					[833]
	8																			\					[010]
	and																			\					[023]
	if																			\ (0x2d)			[014]
		1																		\					[010]
		dfcntrl!																\					[854]
		sxfrctl0@																\					[82a]
		1a																		\					[010]
		or																		\					[024]
		sxfrctl0!																\					[82b]
		simode1@																\					[83b]
		8																		\					[010]
		invert																	\					[026]
		and																		\					[023]
		simode1!																\					[83c]
		8																		\					[010]
		scsi-int1!																\					[832]
		4																		\					[010]
		seq-addr!																\					[84a]
	then																		\					[0b2]
	scsi-stat1@																	\					[833]
	4																			\					[010]
	and																			\					[023]
	if																			\ (0xe)				[014]
		sxfrctl1@																\					[82c]
		20																		\					[010]
		invert																	\					[026]
		and																		\					[023]
		sxfrctl1!																\					[82d]
	then																		\					[0b2]
	4																			\					[010]
	clrint!																		\					[85d]
	-1																			\					[0a4]
	to hw-status																\					[0c3 8a8]
	;																			\					[0c2]


: send-message-out																\ (8ac)				[0b6 0b7]
	0a0																			\					[010]
	3																			\					[010]
	mem-b!																		\					[821]
	3																			\					[010]
	mem-b@																		\					[820]
	10																			\					[010]
	and																			\					[023]
	if																			\ (0x28)			[014]
		." wanted extended message...barf"										\					[012 090]
		cr																		\					[092]
	else																		\ (0x22)			[013 0b2]
		8																		\					[010]
		6																		\					[010]
		mem-b!																	\					[821]
		begin																	\					[0b1]
			3																	\					[010]
			mem-b@																\					[820]
			1																	\					[010]
			and																	\					[023]
			0=																	\					[034]
		until																	\ (0xfff1)			[014]
	then																		\					[0b2]
	;																			\					[0c2]


: handle-sync-negotiate															\ (8ad)				[0b6 0b7]
	2																			\					[0a7]
	seq-addr!																	\					[84a]
	3																			\					[0a8]
	mem-b@																		\					[820]
	0e0																			\					[010]
	and																			\					[023]
	0a0																			\					[010]
	<>																			\					[03d]
	if																			\ (0x9)				[014]
		0																		\					[0a5]
		his-id																	\					[870]
		scratch!																\					[842]
		exit																	\					[033]
	then																		\					[0b2]
	his-id																		\					[870]
	scratch@																	\					[841]
	8f																			\					[010]
	=																			\					[03c]
	if																			\ (0x8)				[014]
		0																		\					[0a5]
		his-id																	\					[870]
		scratch!																\					[842]
	then																		\					[0b2]
	send-message-out															\					[8ac]
	;																			\					[0c2]


: handle-interrupt																\ (8ae)				[0b6 0b7]
	pause																		\					[88c]
	intstat@																	\					[85b]
	2																			\					[0a7]
	and																			\					[023]
	if																			\ (0x5)				[014]
		handle-command-complete													\					[8aa]
	then																		\					[0b2]
	intstat@																	\					[85b]
	1																			\					[0a6]
	and																			\					[023]
	if																			\ (0x8e)			[014]
		intstat@																\					[85b]
		4																		\					[010]
		rshift																	\					[028]
		case																	\					[0c4]
			0																	\					[010]
			of																	\ (0x11)			[01c]
				1																\					[0a6]
				clrint!															\					[85d]
				handle-sync-negotiate											\					[8ad]
				unpause															\					[88d]
				wait-for-int													\					[8a7]
				intstat@														\					[85b]
				exit															\					[033]
			endof																\ (0x6d)			[0c6]
			3																	\					[010]
			of																	\ (0xf)				[01c]
				1																\					[0a6]
				clrint!															\					[85d]
				unpause															\					[88d]
				wait-for-int													\					[8a7]
				intstat@														\					[85b]
				exit															\					[033]
			endof																\ (0x58)			[0c6]
			5																	\					[010]
			of																	\ (0x2c)			[01c]
				sxfrctl0@														\					[82a]
				2																\					[010]
				or																\					[024]
				sxfrctl0!														\					[82b]
				simode1@														\					[83b]
				8																\					[010]
				invert															\					[026]
				and																\					[023]
				simode1!														\					[83c]
				6																\					[010]
				mem-b@															\					[820]
				drop															\					[046]
				0																\					[0a5]
				seq-addr!														\					[84a]
				1																\					[0a6]
				clrint!															\					[85d]
				2																\					[0a7]
				to hw-status													\					[0c3 8a8]
			endof																\ (0x26)			[0c6]
			." Unexpected Sequencer Interrupt!"									\					[012 090]
			cr																	\					[092]
		endcase																	\					[0c5]
	then																		\					[0b2]
	intstat@																	\					[85b]
	4																			\					[010]
	and																			\					[023]
	if																			\ (0x5)				[014]
		handle-scsi-ints														\					[8ab]
	then																		\					[0b2]
	intstat@																	\					[85b]
	0f																			\					[010]
	and																			\					[023]
	unpause																		\					[88d]
	;																			\					[0c2]


: execute-command																\ (8af)				[0b6 0b7]
	pause																		\					[88c]
	setup-scb																	\					[878]
	send-scb																	\					[89f]
	789x?																		\					[806]
	if																			\ (0x5)				[014]
		set-qin																	\					[892]
	then																		\					[0b2]
	0																			\					[0a5]
	to hw-status																\					[0c3 8a8]
	0																			\					[0a5]
	to hw-error																	\					[0c3 8a9]
	unpause																		\					[88d]
	wait-for-int																\					[8a7]
	begin																		\					[0b1]
		handle-interrupt														\					[8ae]
		0=																		\					[034]
	until																		\ (0xfffc)			[014]
	teardown-scb																\					[879]
	hw-error																	\					[8a9]
	?dup																		\					[050]
	if																			\ (0x4)				[014]
		exit																	\					[033]
	then																		\					[0b2]
	hw-status																	\					[8a8]
	0																			\					[0a5]
	;																			\					[0c2]


: close-hardware																\ (8b0)				[0b6 0b7]
	free-sg-list																\					[86a]
	free-dummy																	\					[827]
	unmap-mem-regs																\					[81f]
	;																			\					[0c2]


: open-hardware																	\ (8b1)				[0b6 0b7]
	map-mem-regs																\					[81e]
	chip-reset																	\					[850]
	read-nvram																	\					[887]
	nvram-get-host-id															\					[888]
	set-my-id																	\					[873]
	clear-scbs																	\					[893]
	clear-scratch																\					[88e]
	789x?																		\					[806]
	if																			\ (0xb)				[014]
		40																		\					[010]
	else																		\ (0x9)				[013 0b2]
		0																		\					[010]
	then																		\					[0b2]
	cmd-cntrl!																	\					[890]
	download-sequencer															\					[89d]
	if																			\ (0x23)			[014]
		" Sequencer download failed!"											\					[012]
		warning																	\					[80c]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	reset-channel																\					[8a6]
	nvram-get-termination														\					[889]
	select-termination															\					[8a1]
	reset-bus																	\					[8a5]
	32																			\					[010]
	seq-ctl!																	\					[844]
	0																			\					[0a5]
	seq-addr!																	\					[84a]
	80																			\					[010]
	brkaddr!																	\					[84b]
	80																			\					[010]
	sxfrctl0!																	\					[82b]
	unpause																		\					[88d]
	create-sg-list																\					[869]
	create-dummy																\					[826]
	-1																			\					[0a4]
	;																			\					[0c2]



external

: reopen-hardware																\ (8b2)				[0ca 0b7]
	-1																			\					[0a4]
	;																			\					[0c2]


: reclose-hardware																\ (8b3)				[0ca 0b7]
	;																			\					[0c2]


: bus-reset																		\ (8b4)				[0ca 0b7]
	reset-bus																	\					[8a5]
	;																			\					[0c2]

8000 constant my-max															\ (8b5 8000)		[010 0ca 0ba]

: max-transfer																	\ (8b6)				[0ca 0b7]
	apple-max-transfer?															\					[804]
	if																			\ (0x8)				[014]
		my-max																	\					[8b5]
	else																		\ (0x21)			[013 0b2]
		" max-transfer"															\					[012]
		['] $call-parent														\					[011 209]
		catch																	\					[217]
		if																		\ (0x6)				[014]
			2drop																\					[052]
			my-max																\					[8b5]
		then																	\					[0b2]
		my-max																	\					[8b5]
		min																		\					[02e]
	then																		\					[0b2]
	;																			\					[0c2]


: set-timeout																	\ (8b7)				[0ca 0b7]
	drop																		\					[046]
	;																			\					[0c2]


headers

-1 value inq-buf																\ (8b8 -1)			[0a4 0b6 0b8]
-1 value sense-buf																\ (8b9 -1)			[0a4 0b6 0b8]
0 value #retries																\ (8ba 0)			[0a5 0b6 0b8]

: classify-sense																\ (8bb)				[0b6 0b7]
	debug?																		\					[80a]
	if																			\ (0x35)			[014]
		base																	\					[0a0]
		@																		\					[06d]
		>r																		\					[030]
		hex																		\					[010 0a0 072]
		." Sense:  "															\					[012 090]
		sense-buf																\					[8b9]
		11																		\					[010]
		bounds																	\					[0ac]
		do																		\ (0x9)				[017]
			i																	\					[019]
			c@																	\					[071]
			3																	\					[0a8]
			u.r																	\					[09c]
		loop																	\ (0xfffb)			[015]
		."  ..."																\					[012 090]
		cr																		\					[092]
		r>																		\					[031]
		base																	\					[0a0]
		!																		\					[072]
	then																		\					[0b2]
	sense-buf																	\					[8b9]
	dup																			\					[047]
	c@																			\					[071]
	7f																			\					[010]
	and																			\					[023]
	70																			\					[010]
	<>																			\					[03d]
	if																			\ (0x6)				[014]
		drop																	\					[046]
		-1																		\					[0a4]
		exit																	\					[033]
	then																		\					[0b2]
	dup																			\					[047]
	2+																			\					[0a7 01e]
	c@																			\					[071]
	0e0																			\					[010]
	and																			\					[023]
	if																			\ (0x6)				[014]
		drop																	\					[046]
		-1																		\					[0a4]
		exit																	\					[033]
	then																		\					[0b2]
	2+																			\					[0a7 01e]
	c@																			\					[071]
	0f																			\					[010]
	and																			\					[023]
	dup																			\					[047]
	1																			\					[0a6]
	<=																			\					[043]
	if																			\ (0x6)				[014]
		drop																	\					[046]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	dup																			\					[047]
	2																			\					[0a7]
	=																			\					[03c]
	if																			\ (0x29)			[014]
		drop																	\					[046]
		sense-buf																\					[8b9]
		0c																		\					[010]
		+																		\					[01e]
		c@																		\					[071]
		3a																		\					[010]
		=																		\					[03c]
		sense-buf																\					[8b9]
		0d																		\					[010]
		+																		\					[01e]
		c@																		\					[071]
		0=																		\					[034]
		and																		\					[023]
		if																		\ (0x7)				[014]
			-1																	\					[0a4]
		else																	\ (0x5)				[013 0b2]
			1																	\					[0a6]
		then																	\					[0b2]
		exit																	\					[033]
	then																		\					[0b2]
	dup																			\					[047]
	3																			\					[0a8]
	=																			\					[03c]
	over																		\					[048]
	6																			\					[010]
	=																			\					[03c]
	or																			\					[024]
	swap																		\					[049]
	0b																			\					[010]
	=																			\					[03c]
	or																			\					[024]
	if																			\ (0x7)				[014]
		1																		\					[0a6]
	else																		\ (0x5)				[013 0b2]
		-1																		\					[0a4]
	then																		\					[0b2]
	;																			\					[0c2]

0 value open-count																\ (8bc 0)			[0a5 0b6 0b8]


external

: decode-unit																	\ (8bd)				[0ca 0b7]
	parse-2int																	\					[11b]
	;																			\					[0c2]


: open																			\ (8be)				[0ca 0b7]
	open-count																	\					[8bc]
	if																			\ (0x15)			[014]
		reopen-hardware															\					[8b2]
		dup																		\					[047]
		if																		\ (0xa)				[014]
			open-count															\					[8bc]
			1+																	\					[0a6 01e]
			to open-count														\					[0c3 8bc]
		then																	\					[0b2]
		exit																	\					[033]
	else																		\ (0x23)			[013 0b2]
		open-hardware															\					[8b1]
		dup																		\					[047]
		if																		\ (0x1b)			[014]
			1																	\					[0a6]
			to open-count														\					[0c3 8bc]
			100																	\					[010]
			dma-alloc															\					[818]
			to sense-buf														\					[0c3 8b9]
			100																	\					[010]
			dma-alloc															\					[818]
			to inq-buf															\					[0c3 8b8]
		then																	\					[0b2]
	then																		\					[0b2]
	;																			\					[0c2]


: close																			\ (8bf)				[0ca 0b7]
	open-count																	\					[8bc]
	1-																			\					[0a6 01f]
	to open-count																\					[0c3 8bc]
	open-count																	\					[8bc]
	if																			\ (0x8)				[014]
		reclose-hardware														\					[8b3]
	else																		\ (0x18)			[013 0b2]
		close-hardware															\					[8b0]
		inq-buf																	\					[8b8]
		100																		\					[010]
		dma-free																\					[819]
		sense-buf																\					[8b9]
		100																		\					[010]
		dma-free																\					[819]
	then																		\					[0b2]
	;																			\					[0c2]


headers

create sense-cmd																\ (8c0)				[0b6 0bb]
3																				\					[0a8]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0ff																				\					[010]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]

: get-sense																		\ (8c1)				[0b6 0b7]
	sense-buf																	\					[8b9]
	0ff																			\					[010]
	-1																			\					[0a4]
	sense-cmd																	\					[8c0]
	6																			\					[010]
	execute-command																\					[8af]
	0=																			\					[034]
	if																			\ (0x4)				[014]
		drop																	\					[046]
	then																		\					[0b2]
	;																			\					[0c2]


: delay-retry																	\ (8c2)				[0b6 0b7]
	1000																		\					[010]
	0																			\					[0a5]
	do																			\ (0x5)				[017]
	loop																		\ (0xffff)			[015]
	;																			\					[0c2]

0 value statbyte																\ (8c3 0)			[0a5 0b6 0b8]

: retry?																		\ (8c4)				[0b6 0b7]
	case																		\					[0c4]
		0																		\					[0a5]
		of																		\ (0x8)				[01c]
			to statbyte															\					[0c3 8c3]
		endof																	\ (0x10)			[0c6]
		bus-reset																\					[8b4]
		of																		\ (0x7)				[01c]
			-1																	\					[0a4]
			exit																\					[033]
		endof																	\ (0x6)				[0c6]
		-1																		\					[0a4]
		0																		\					[0a5]
		exit																	\					[033]
	endcase																		\					[0c5]
	statbyte																	\					[8c3]
	0=																			\					[034]
	if																			\ (0x6)				[014]
		0																		\					[0a5]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	statbyte																	\					[8c3]
	2																			\					[0a7]
	and																			\					[023]
	if																			\ (0x2f)			[014]
		get-sense																\					[8c1]
		classify-sense															\					[8bb]
		case																	\					[0c4]
			0																	\					[0a5]
			of																	\ (0x8)				[01c]
				0																\					[0a5]
				0																\					[0a5]
				exit															\					[033]
			endof																\ (0x11)			[0c6]
			-1																	\					[0a4]
			of																	\ (0xc)				[01c]
				sense-buf														\					[8b9]
				0																\					[0a5]
				statbyte														\					[8c3]
				0																\					[0a5]
				exit															\					[033]
			endof																\ (0x3)				[0c6]
		endcase																	\					[0c5]
		#retries																\					[8ba]
		0=																		\					[034]
		if																		\ (0xa)				[014]
			sense-buf															\					[8b9]
			0																	\					[0a5]
			statbyte															\					[8c3]
			0																	\					[0a5]
			exit																\					[033]
		then																	\					[0b2]
	then																		\					[0b2]
	statbyte																	\					[8c3]
	0f5																			\					[010]
	and																			\					[023]
	if																			\ (0x8)				[014]
		-1																		\					[0a4]
		statbyte																\					[8c3]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	#retries																	\					[8ba]
	0=																			\					[034]
	if																			\ (0x8)				[014]
		-1																		\					[0a4]
		statbyte																\					[8c3]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	-1																			\					[0a4]
	;																			\					[0c2]

0 instance value dbuf															\ (8c5 0)			[0a5 0c0 0b6 0b8]
0 instance value dlen															\ (8c6 0)			[0a5 0c0 0b6 0b8]
0 instance value direction-in													\ (8c7 0)			[0a5 0c0 0b6 0b8]
-1 instance value cbuf															\ (8c8 -1)			[0a4 0c0 0b6 0b8]
0 instance value clen															\ (8c9 0)			[0a5 0c0 0b6 0b8]


external

: retry-command																	\ (8ca)				[0ca 0b7]
	to #retries																	\					[0c3 8ba]
	to clen																		\					[0c3 8c9]
	to cbuf																		\					[0c3 8c8]
	to direction-in																\					[0c3 8c7]
	to dlen																		\					[0c3 8c6]
	to dbuf																		\					[0c3 8c5]
	begin																		\					[0b1]
		dbuf																	\					[8c5]
		dlen																	\					[8c6]
		direction-in															\					[8c7]
		cbuf																	\					[8c8]
		clen																	\					[8c9]
		execute-command															\					[8af]
		retry?																	\					[8c4]
		while																	\ (0xf)				[014]
			#retries															\					[8ba]
			1-																	\					[0a6 01f]
			to #retries															\					[0c3 8ba]
			delay-retry															\					[8c2]
	repeat																		\ (0xffe5)			[013 0b2]
	;																			\					[0c2]



headers

: error?																		\ (8cb)				[0b6 0b7]
	dup																			\					[047]
	if																			\ (0xa)				[014]
		swap																	\					[049]
		0=																		\					[034]
		if																		\ (0x4)				[014]
			nip																	\					[04d]
		then																	\					[0b2]
	then																		\					[0b2]
	;																			\					[0c2]



external

: no-data-command																\ (8cc)				[0ca 0b7]
	>r																			\					[030]
	0																			\					[0a5]
	0																			\					[0a5]
	-1																			\					[0a4]
	r>																			\					[031]
	6																			\					[010]
	-1																			\					[0a4]
	retry-command																\					[8ca]
	error?																		\					[8cb]
	;																			\					[0c2]


: short-data-command															\ (8cd)				[0ca 0b7]
	>r																			\					[030]
	>r																			\					[030]
	inq-buf																		\					[8b8]
	swap																		\					[049]
	-1																			\					[0a4]
	r>																			\					[031]
	r>																			\					[031]
	-1																			\					[0a4]
	retry-command																\					[8ca]
	error?																		\					[8cb]
	dup																			\					[047]
	0=																			\					[034]
	if																			\ (0x6)				[014]
		inq-buf																	\					[8b8]
		swap																	\					[049]
	then																		\					[0b2]
	;																			\					[0c2]



headers

: 3c!																			\ (8ce)				[0b6 0b7]
	>r																			\					[030]
	lbsplit																		\					[07e]
	drop																		\					[046]
	r@																			\					[032]
	c!																			\					[075]
	r@																			\					[032]
	1+																			\					[0a6 01e]
	c!																			\					[075]
	r>																			\					[031]
	2+																			\					[0a7 01e]
	c!																			\					[075]
	;																			\					[0c2]

create inquiry-cmd																\ (8cf)				[0b6 0bb]
12																				\					[010]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0ff																				\					[010]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]

: inquiry																		\ (8d0)				[0b6 0b7]
	inq-buf																		\					[8b8]
	0ff																			\					[010]
	-1																			\					[0a4]
	inquiry-cmd																	\					[8cf]
	6																			\					[010]
	8																			\					[010]
	retry-command																\					[8ca]
	error?																		\					[8cb]
	;																			\					[0c2]


: probe-target																	\ (8d1)				[0b6 0b7]
	0																			\					[0a5]
	swap																		\					[049]
	set-address																	\					[872]
	inquiry																		\					[8d0]
	0=																			\					[034]
	;																			\					[0c2]


: inq@																			\ (8d2)				[0b6 0b7]
	inq-buf																		\					[8b8]
	+																			\					[01e]
	c@																			\					[071]
	;																			\					[0c2]


: .scsi1-inquiry																\ (8d3)				[0b6 0b7]
	inq-buf																		\					[8b8]
	5																			\					[010]
	ca+																			\					[05e]
	4																			\					[010]
	inq@																		\					[8d2]
	0fa																			\					[010]
	min																			\					[02e]
	type																		\					[090]
	;																			\					[0c2]


: .scsi2-inquiry																\ (8d4)				[0b6 0b7]
	inq-buf																		\					[8b8]
	8																			\					[010]
	ca+																			\					[05e]
	1c																			\					[010]
	type																		\					[090]
	;																			\					[0c2]


: show-lun																		\ (8d5)				[0b6 0b7]
	over																		\					[048]
	swap																		\					[049]
	set-address																	\					[872]
	inquiry																		\					[8d0]
	if																			\ (0x5)				[014]
		drop																	\					[046]
		exit																	\					[033]
	then																		\					[0b2]
	0																			\					[0a5]
	inq@																		\					[8d2]
	60																			\					[010]
	and																			\					[023]
	if																			\ (0x5)				[014]
		drop																	\					[046]
		exit																	\					[033]
	then																		\					[0b2]
	."   Unit "																	\					[012 090]
	.																			\					[09d]
	."   "																		\					[012 090]
	1																			\					[0a6]
	inq@																		\					[8d2]
	80																			\					[010]
	and																			\					[023]
	if																			\ (0x10)			[014]
		." Removable "															\					[012 090]
	then																		\					[0b2]
	0																			\					[0a5]
	inq@																		\					[8d2]
	case																		\					[0c4]
		0																		\					[0a5]
		of																		\ (0xd)				[01c]
			." Disk "															\					[012 090]
		endof																	\ (0x86)			[0c6]
		1																		\					[0a6]
		of																		\ (0xd)				[01c]
			." Tape "															\					[012 090]
		endof																	\ (0x77)			[0c6]
		2																		\					[0a7]
		of																		\ (0x10)			[01c]
			." Printer "														\					[012 090]
		endof																	\ (0x65)			[0c6]
		3																		\					[0a8]
		of																		\ (0x12)			[01c]
			." Processor "														\					[012 090]
		endof																	\ (0x51)			[0c6]
		4																		\					[010]
		of																		\ (0xd)				[01c]
			." WORM "															\					[012 090]
		endof																	\ (0x3e)			[0c6]
		5																		\					[010]
		of																		\ (0x18)			[01c]
			." Read Only device"												\					[012 090]
		endof																	\ (0x20)			[0c6]
		." Device type "														\					[012 090]
		dup																		\					[047]
		.h																		\					[0a0 06d 049 010 0a0 072 09d 0a0 072]
	endcase																		\					[0c5]
	4																			\					[010]
	spaces																		\					[0a5 02f 0a5 018 0a9 08f 015]
	3																			\					[0a8]
	inq@																		\					[8d2]
	0f																			\					[010]
	and																			\					[023]
	2																			\					[0a7]
	=																			\					[03c]
	if																			\ (0x8)				[014]
		.scsi2-inquiry															\					[8d4]
	else																		\ (0x6)				[013 0b2]
		.scsi1-inquiry															\					[8d3]
	then																		\					[0b2]
	cr																			\					[092]
	;																			\					[0c2]



external

: show-children																	\ (8d6)				[0ca 0b7]
	open																		\					[8be]
	0=																			\					[034]
	if																			\ (0x24)			[014]
		." Can't open SCSI host adapter"										\					[012 090]
		cr																		\					[092]
		exit																	\					[033]
	then																		\					[0b2]
	" wide"																		\					[012]
	get-my-property																\					[21a]
	if																			\ (0xb)				[014]
		8																		\					[010]
	else																		\ (0xa)				[013 0b2]
		2drop																	\					[052]
		10																		\					[010]
	then																		\					[0b2]
	0																			\					[0a5]
	do																			\ (0x29)			[017]
		i																		\					[019]
		probe-target															\					[8d1]
		if																		\ (0x20)			[014]
			." Target "															\					[012 090]
			i																	\					[019]
			.																	\					[09d]
			cr																	\					[092]
			8																	\					[010]
			0																	\					[0a5]
			do																	\ (0x9)				[017]
				i																\					[019]
				j																\					[01a]
				show-lun														\					[8d5]
			loop																\ (0xfffb)			[015]
		then																	\					[0b2]
	loop																		\ (0xffdb)			[015]
	close																		\					[8bf]
	;																			\					[0c2]


: get-scsi-type																	\ (8d7)				[0ca 0b7]
	open																		\					[8be]
	0=																			\					[034]
	if																			\ (0x6)				[014]
		2drop																	\					[052]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	swap																		\					[049]
	set-address																	\					[872]
	inquiry																		\					[8d0]
	if																			\ (0x7)				[014]
		0																		\					[0a5]
	else																		\ (0x19)			[013 0b2]
		0																		\					[0a5]
		inq@																	\					[8d2]
		dup																		\					[047]
		7f																		\					[010]
		=																		\					[03c]
		if																		\ (0x8)				[014]
			drop																\					[046]
			0																	\					[0a5]
		else																	\ (0x5)				[013 0b2]
			-1																	\					[0a4]
		then																	\					[0b2]
	then																		\					[0b2]
	close																		\					[8bf]
	;																			\					[0c2]


headers

create test-unit-rdy-cmd														\ (8d8)				[0b6 0bb]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
create send-diagnostic-cmd														\ (8d9)				[0b6 0bb]
1d																				\					[010]
c,																				\					[0d0]
4																				\					[010]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]

: send-diagnostic																\ (8da)				[0b6 0b7]
	send-diagnostic-cmd															\					[8d9]
	no-data-command																\					[8cc]
	;																			\					[0c2]



external

: diagnose																		\ (8db)				[0ca 0b7]
	0																			\					[0a5]
	0																			\					[0a5]
	-1																			\					[0a4]
	test-unit-rdy-cmd															\					[8d8]
	6																			\					[010]
	-1																			\					[0a4]
	retry-command																\					[8ca]
	if																			\ (0x82)			[014]
		." Test unit ready failed - "											\					[012 090]
		if																		\ (0x2a)			[014]
			." hardware error (no such device?)"								\					[012 090]
			cr																	\					[092]
		else																	\ (0x37)			[013 0b2]
			." extended status = "												\					[012 090]
			cr																	\					[092]
			base																\					[0a0]
			@																	\					[06d]
			>r																	\					[030]
			hex																	\					[010 0a0 072]
			8																	\					[010]
			bounds																\					[0ac]
			?do																	\ (0x8)				[018]
				i																\					[019]
				3																\					[0a8]
				u.r																\					[09c]
			loop																\ (0xfffc)			[015]
			cr																	\					[092]
			r>																	\					[031]
			base																\					[0a0]
			!																	\					[072]
		then																	\					[0b2]
		-1																		\					[0a4]
	else																		\ (0x6)				[013 0b2]
		send-diagnostic															\					[8da]
	then																		\					[0b2]
	;																			\					[0c2]


headers

-1 value old-control															\ (8dc -1)			[010 0b6 0b8]
-1 value old-rombase															\ (8dd -1)			[010 0b6 0b8]
-1 value my-regs																\ (8de -1)			[010 0b6 0b8]
-1 value my-rom																	\ (8df -1)			[010 0b6 0b8]

: rom-map																		\ (8e0)				[0b6 0b7]
	my-space																	\					[103]
	2000014																		\					[010]
	+																			\					[01e]
	get-base-address															\					[814]
	100																			\					[010]
	" map-in"																	\					[012]
	$call-parent																\					[209]
	to my-regs																	\					[0c3 8de]
	my-space																	\					[103]
	2000030																		\					[010]
	+																			\					[01e]
	get-base-address															\					[814]
	10000																		\					[010]
	" map-in"																	\					[012]
	$call-parent																\					[209]
	to my-rom																	\					[0c3 8df]
	my-space																	\					[103]
	4																			\					[010]
	+																			\					[01e]
	dup																			\					[047]
	" config-w@"																\					[012]
	$call-parent																\					[209]
	dup																			\					[047]
	to old-control																\					[0c3 8dc]
	3																			\					[0a8]
	or																			\					[024]
	swap																		\					[049]
	" config-w!"																\					[012]
	$call-parent																\					[209]
	my-space																	\					[103]
	30																			\					[010]
	+																			\					[01e]
	dup																			\					[047]
	" config-l@"																\					[012]
	$call-parent																\					[209]
	dup																			\					[047]
	to old-rombase																\					[0c3 8dd]
	1																			\					[0a6]
	or																			\					[024]
	swap																		\					[049]
	" config-l!"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: rom-unmap																		\ (8e1)				[0b6 0b7]
	my-regs																		\					[8de]
	100																			\					[010]
	" map-out"																	\					[012]
	$call-parent																\					[209]
	my-rom																		\					[8df]
	10000																		\					[010]
	" map-out"																	\					[012]
	$call-parent																\					[209]
	old-control																	\					[8dc]
	my-space																	\					[103]
	4																			\					[010]
	+																			\					[01e]
	" config-w!"																\					[012]
	$call-parent																\					[209]
	old-rombase																	\					[8dd]
	my-space																	\					[103]
	30																			\					[010]
	+																			\					[01e]
	" config-l!"																\					[012]
	$call-parent																\					[209]
	-1																			\					[010]
	to my-regs																	\					[0c3 8de]
	-1																			\					[010]
	to my-rom																	\					[0c3 8df]
	;																			\					[0c2]


: set-second-page																\ (8e2)				[0b6 0b7]
	my-regs																		\					[8de]
	1e																			\					[010]
	ca+																			\					[05e]
	dup																			\					[047]
	20																			\					[010]
	swap																		\					[049]
	rb!																			\					[231]
	begin																		\					[0b1]
		my-regs																	\					[8de]
		1e																		\					[010]
		ca+																		\					[05e]
		rb@																		\					[230]
		80																		\					[010]
		and																		\					[023]
		0=																		\					[034]
	until																		\ (0xffee)			[014]
	dup																			\					[047]
	rot																			\					[04a]
	if																			\ (0xb)				[014]
		22																		\					[010]
	else																		\ (0x9)				[013 0b2]
		20																		\					[010]
	then																		\					[0b2]
	2dup																		\					[053]
	2dup																		\					[053]
	swap																		\					[049]
	rb!																			\					[231]
	8																			\					[010]
	or																			\					[024]
	swap																		\					[049]
	rb!																			\					[231]
	swap																		\					[049]
	rb!																			\					[231]
	0																			\					[0a5]
	swap																		\					[049]
	rb!																			\					[231]
	;																			\					[0c2]

0 value string-length															\ (8e3 0)			[0a5 0b6 0b8]
create string-buffer															\ (8e4)				[0b6 0bb]
256																				\					[010]
allot																			\					[0a5 02f 0a5 018 0a5 0d0 015]
0 value string-prop-adr															\ (8e5 0)			[0a5 0b6 0b8]
0 value string-prop-len															\ (8e6 0)			[0a5 0b6 0b8]
0 value saved-prop-adr															\ (8e7 0)			[0a5 0b6 0b8]
0 value saved-prop-len															\ (8e8 0)			[0a5 0b6 0b8]

: read-byte																		\ (8e9)				[0b6 0b7]
	dup																			\					[047]
	3																			\					[0a8]
	pick																		\					[04e]
	swap																		\					[049]
	ca+																			\					[05e]
	c@																			\					[071]
	swap																		\					[049]
	1+																			\					[0a6 01e]
	swap																		\					[049]
	;																			\					[0c2]


: read-addr																		\ (8ea)				[0b6 0b7]
	dup																			\					[047]
	3																			\					[0a8]
	pick																		\					[04e]
	ca+																			\					[05e]
	;																			\					[0c2]


: find-header																	\ (8eb)				[0b6 0b7]
	400																			\					[010]
	<																			\					[03a]
	if																			\ (0x6)				[014]
		drop																	\					[046]
		-1																		\					[0a4]
		exit																	\					[033]
	then																		\					[0b2]
	9fc4																		\					[010]
	0																			\					[0a5]
	do																			\ (0x32)			[017]
		dup																		\					[047]
		i																		\					[019]
		chars																	\					[066]
		+																		\					[01e]
		dup																		\					[047]
		c@																		\					[071]
		4a																		\					[010]
		=																		\					[03c]
		if																		\ (0x1e)			[014]
			" Joy!peffpwpc"														\					[012]
			comp																\					[07a]
			0=																	\					[034]
			if																	\ (0x7)				[014]
				drop															\					[046]
				i																\					[019]
				unloop															\					[089]
				exit															\					[033]
			then																\					[0b2]
		else																	\ (0x5)				[013 0b2]
			drop																\					[046]
		then																	\					[0b2]
	loop																		\ (0xffd2)			[015]
	drop																		\					[046]
	-1																			\					[0a4]
	;																			\					[0c2]

7 constant header-offset														\ (8ec 7)			[010 0b6 0ba]

: 3drop																			\ (8ed)				[0b6 0b7]
	3drop																		\					[046 052]
	;																			\					[0c2]


: find-property																	\ (8ee)				[0b6 0b7]
	2dup																		\					[053]
	find-header																	\					[8eb]
	dup																			\					[047]
	header-offset																\					[8ec]
	<																			\					[03a]
	if																			\ (0x8)				[014]
		3drop																	\					[8ed]
		0																		\					[0a5]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	header-offset																\					[8ec]
	-																			\					[01f]
	begin																		\					[0b1]
		read-byte																\					[8e9]
		case																	\					[0c4]
			12																	\					[010]
			of																	\ (0x14)			[01c]
				read-byte														\					[8e9]
				to string-length												\					[0c3 8e3]
				read-addr														\					[8ea]
				string-buffer													\					[8e4]
				string-length													\					[8e3]
				move															\					[078]
				string-length													\					[8e3]
				+																\					[01e]
			endof																\ (0x85)			[0c6]
			7b																	\					[010]
			of																	\ (0xc)				[01c]
				3drop															\					[8ed]
				saved-prop-adr													\					[8e7]
				saved-prop-len													\					[8e8]
				exit															\					[033]
			endof																\ (0x73)			[0c6]
			1																	\					[010]
			of																	\ (0x64)			[01c]
				read-byte														\					[8e9]
				case															\					[0c4]
					15															\					[010]
					of															\ (0x22)			[01c]
						string-buffer											\					[8e4]
						string-length											\					[8e3]
						encode-bytes											\					[115]
						saved-prop-len											\					[8e8]
						0=														\					[034]
						if														\ (0xc)				[014]
							to saved-prop-len									\					[0c3 8e8]
							to saved-prop-adr									\					[0c3 8e7]
						else													\ (0xa)				[013 0b2]
							to string-prop-len									\					[0c3 8e6]
							to string-prop-adr									\					[0c3 8e5]
						then													\					[0b2]
					endof														\ (0x36)			[0c6]
					12															\					[010]
					of															\ (0x15)			[01c]
						saved-prop-adr											\					[8e7]
						saved-prop-len											\					[8e8]
						string-prop-adr											\					[8e5]
						string-prop-len											\					[8e6]
						encode+													\					[112]
						to saved-prop-len										\					[0c3 8e8]
						to saved-prop-adr										\					[0c3 8e7]
					endof														\ (0x1b)			[0c6]
					10															\					[010]
					of															\ (0xc)				[01c]
						3drop													\					[8ed]
						saved-prop-adr											\					[8e7]
						saved-prop-len											\					[8e8]
						exit													\					[033]
					endof														\ (0x9)				[0c6]
					drop														\					[046]
					3drop														\					[8ed]
					0															\					[0a5]
					0															\					[0a5]
					exit														\					[033]
				endcase															\					[0c5]
			endof																\ (0x9)				[0c6]
			drop																\					[046]
			3drop																\					[8ed]
			0																	\					[0a5]
			0																	\					[0a5]
			exit																\					[033]
		endcase																	\					[0c5]
		2dup																	\					[053]
		<																		\					[03a]
	until																		\ (0xff5d)			[014]
	3drop																		\					[8ed]
	0																			\					[0a5]
	0																			\					[0a5]
	;																			\					[0c2]

1 constant s_st																	\ (8ef 1)			[0a6 0b6 0ba]
2 constant s_m1																	\ (8f0 2)			[0a7 0b6 0ba]
3 constant s_f																	\ (8f1 3)			[0a8 0b6 0ba]
4 constant s_mt																	\ (8f2 4)			[010 0b6 0ba]
5 constant s_cm																	\ (8f3 5)			[010 0b6 0ba]
6 constant s_md																	\ (8f4 6)			[010 0b6 0ba]
7 constant s_e																	\ (8f5 7)			[010 0b6 0ba]
variable p_state																\ (8f6)				[0b6 0b9]
variable t																		\ (8f7)				[0b6 0b9]
variable ip																		\ (8f8)				[0b6 0b9]
variable op																		\ (8f9)				[0b6 0b9]
variable mpos																	\ (8fa)				[0b6 0b9]

: ipc@																			\ (8fb)				[0b6 0b7]
	ip																			\					[8f8]
	@																			\					[06d]
	c@																			\					[071]
	;																			\					[0c2]


: ip++																			\ (8fc)				[0b6 0b7]
	ip																			\					[8f8]
	@																			\					[06d]
	1+																			\					[0a6 01e]
	ip																			\					[8f8]
	!																			\					[072]
	;																			\					[0c2]


: ipc@++																		\ (8fd)				[0b6 0b7]
	ipc@																		\					[8fb]
	ip++																		\					[8fc]
	;																			\					[0c2]


: t!																			\ (8fe)				[0b6 0b7]
	t																			\					[8f7]
	!																			\					[072]
	;																			\					[0c2]


: t@																			\ (8ff)				[0b6 0b7]
	t																			\					[8f7]
	@																			\					[06d]
	;																			\					[0c2]


: op@																			\ (900)				[0b6 0b7]
	op																			\					[8f9]
	@																			\					[06d]
	;																			\					[0c2]


: mpos@																			\ (901)				[0b6 0b7]
	mpos																		\					[8fa]
	@																			\					[06d]
	;																			\					[0c2]


: mpos!																			\ (902)				[0b6 0b7]
	mpos																		\					[8fa]
	!																			\					[072]
	;																			\					[0c2]


: st!																			\ (903)				[0b6 0b7]
	p_state																		\					[8f6]
	!																			\					[072]
	;																			\					[0c2]

0 value bufst																	\ (904 0)			[0a5 0b6 0b8]
1000 constant buflen															\ (905 1000)		[010 0b6 0ba]
0 value buf-offset																\ (906 0)			[0a5 0b6 0b8]
0 value propadr																	\ (907 0)			[0a5 0b6 0b8]
0 value proplen																	\ (908 0)			[0a5 0b6 0b8]

: write-buffer																	\ (909)				[0b6 0b7]
	>r																			\					[030]
	bufst																		\					[904]
	r@																			\					[032]
	encode-bytes																\					[115]
	proplen																		\					[908]
	0=																			\					[034]
	invert																		\					[026]
	if																			\ (0xa)				[014]
		propadr																	\					[907]
		proplen																	\					[908]
		2swap																	\					[055]
		encode+																	\					[112]
	then																		\					[0b2]
	to proplen																	\					[0c3 908]
	to propadr																	\					[0c3 907]
	op@																			\					[900]
	r@																			\					[032]
	-																			\					[01f]
	op																			\					[8f9]
	!																			\					[072]
	buf-offset																	\					[906]
	r>																			\					[031]
	+																			\					[01e]
	to buf-offset																\					[0c3 906]
	;																			\					[0c2]


: op-off																		\ (90a)				[0b6 0b7]
	op@																			\					[900]
	bufst																		\					[904]
	-																			\					[01f]
	dup																			\					[047]
	;																			\					[0c2]


: flush-buffer																	\ (90b)				[0b6 0b7]
	op-off																		\					[90a]
	0>																			\					[038]
	if																			\ (0x8)				[014]
		write-buffer															\					[909]
	else																		\ (0x5)				[013 0b2]
		drop																	\					[046]
	then																		\					[0b2]
	;																			\					[0c2]


: check-op																		\ (90c)				[0b6 0b7]
	op-off																		\					[90a]
	buflen																		\					[905]
	=																			\					[03c]
	if																			\ (0x8)				[014]
		write-buffer															\					[909]
	else																		\ (0x5)				[013 0b2]
		drop																	\					[046]
	then																		\					[0b2]
	;																			\					[0c2]


: set-mpos																		\ (90d)				[0b6 0b7]
	op@																			\					[900]
	bufst																		\					[904]
	-																			\					[01f]
	buf-offset																	\					[906]
	+																			\					[01e]
	swap																		\					[049]
	-																			\					[01f]
	mpos!																		\					[902]
	;																			\					[0c2]


: opc!																			\ (90e)				[0b6 0b7]
	check-op																	\					[90c]
	op@																			\					[900]
	c!																			\					[075]
	op@																			\					[900]
	1+																			\					[0a6 01e]
	op																			\					[8f9]
	!																			\					[072]
	;																			\					[0c2]


: op++=mpos																		\ (90f)				[0b6 0b7]
	mpos@																		\					[901]
	buf-offset																	\					[906]
	<																			\					[03a]
	if																			\ (0x8)				[014]
		propadr																	\					[907]
	else																		\ (0x9)				[013 0b2]
		bufst																	\					[904]
		buf-offset																\					[906]
		-																		\					[01f]
	then																		\					[0b2]
	mpos@																		\					[901]
	+																			\					[01e]
	c@																			\					[071]
	opc!																		\					[90e]
	;																			\					[0c2]


: mpos-ptr																		\ (910)				[0b6 0b7]
	bufst																		\					[904]
	mpos@																		\					[901]
	+																			\					[01e]
	buf-offset																	\					[906]
	-																			\					[01f]
	;																			\					[0c2]



headerless

: colon_definition_function_911													\ (911)				[0b5 0b7]
	mpos@																		\					[901]
	swap																		\					[049]
	-																			\					[01f]
	mpos!																		\					[902]
	;																			\					[0c2]


: colon_definition_function_912													\ (912)				[0b5 0b7]
	mpos@																		\					[901]
	1+																			\					[0a6 01e]
	mpos!																		\					[902]
	;																			\					[0c2]


: colon_definition_function_913													\ (913)				[0b5 0b7]
	ipc@++																		\					[8fd]
	opc!																		\					[90e]
	;																			\					[0c2]


: colon_definition_function_914													\ (914)				[0b5 0b7]
	op++=mpos																	\					[90f]
	colon_definition_function_912												\ (912)				[912]
	;																			\					[0c2]


: colon_definition_function_915													\ (915)				[0b5 0b7]
	ipc@																		\					[8fb]
	11																			\					[010]
	>																			\					[03b]
	if																			\ (0x23)			[014]
		ipc@++																	\					[8fd]
		11																		\					[010]
		-																		\					[01f]
		t!																		\					[8fe]
		begin																	\					[0b1]
			colon_definition_function_913										\ (913)				[913]
			t@																	\					[8ff]
			1-																	\					[0a6 01f]
			t!																	\					[8fe]
			t@																	\					[8ff]
			0=																	\					[034]
		until																	\ (0xfff4)			[014]
		s_f																		\					[8f1]
		st!																		\					[903]
	else																		\ (0x8)				[013 0b2]
		s_m1																	\					[8f0]
		st!																		\					[903]
	then																		\					[0b2]
	;																			\					[0c2]


: colon_definition_function_916													\ (916)				[0b5 0b7]
	ipc@++																		\					[8fd]
	t!																			\					[8fe]
	t@																			\					[8ff]
	0f																			\					[010]
	>																			\					[03b]
	if																			\ (0xa)				[014]
		s_mt																	\					[8f2]
		st!																		\					[903]
	else																		\ (0x48)			[013 0b2]
		t@																		\					[8ff]
		0=																		\					[034]
		if																		\ (0x27)			[014]
			begin																\					[0b1]
				ipc@															\					[8fb]
				0=																\					[034]
				while															\ (0x12)			[014]
					t@															\					[8ff]
					0ff															\					[010]
					+															\					[01e]
					t!															\					[8fe]
					ip++														\					[8fc]
			repeat																\ (0xffed)			[013 0b2]
			ipc@++																\					[8fd]
			0f																	\					[010]
			+																	\					[01e]
			t@																	\					[8ff]
			+																	\					[01e]
			t!																	\					[8fe]
		then																	\					[0b2]
		colon_definition_function_913											\ (913)				[913]
		colon_definition_function_913											\ (913)				[913]
		colon_definition_function_913											\ (913)				[913]
		begin																	\					[0b1]
			colon_definition_function_913										\ (913)				[913]
			t@																	\					[8ff]
			1-																	\					[0a6 01f]
			t!																	\					[8fe]
			t@																	\					[8ff]
			0=																	\					[034]
		until																	\ (0xfff4)			[014]
		s_f																		\					[8f1]
		st!																		\					[903]
	then																		\					[0b2]
	;																			\					[0c2]


: colon_definition_function_917													\ (917)				[0b5 0b7]
	ipc@++																		\					[8fd]
	t!																			\					[8fe]
	t@																			\					[8ff]
	0f																			\					[010]
	>																			\					[03b]
	if																			\ (0xa)				[014]
		s_mt																	\					[8f2]
		st!																		\					[903]
	else																		\ (0x21)			[013 0b2]
		801																		\					[010]
		set-mpos																\					[90d]
		t@																		\					[8ff]
		2																		\					[0a7]
		rshift																	\					[028]
		colon_definition_function_911											\ (911)				[911]
		ipc@++																	\					[8fd]
		2																		\					[0a7]
		lshift																	\					[027]
		colon_definition_function_911											\ (911)				[911]
		colon_definition_function_914											\ (914)				[914]
		colon_definition_function_914											\ (914)				[914]
		op++=mpos																\					[90f]
		s_md																	\					[8f4]
		st!																		\					[903]
	then																		\					[0b2]
	;																			\					[0c2]


: colon_definition_function_918													\ (918)				[0b5 0b7]
	1																			\					[0a6]
	set-mpos																	\					[90d]
	t@																			\					[8ff]
	2																			\					[0a7]
	rshift																		\					[028]
	7																			\					[010]
	and																			\					[023]
	colon_definition_function_911												\ (911)				[911]
	ipc@++																		\					[8fd]
	3																			\					[0a8]
	lshift																		\					[027]
	colon_definition_function_911												\ (911)				[911]
	t@																			\					[8ff]
	5																			\					[010]
	rshift																		\					[028]
	1-																			\					[0a6 01f]
	t!																			\					[8fe]
	s_cm																		\					[8f3]
	st!																			\					[903]
	;																			\					[0c2]


: colon_definition_function_919													\ (919)				[0b5 0b7]
	t@																			\					[8ff]
	1f																			\					[010]
	and																			\					[023]
	t!																			\					[8fe]
	t@																			\					[8ff]
	0=																			\					[034]
	if																			\ (0x27)			[014]
		begin																	\					[0b1]
			ipc@																\					[8fb]
			0=																	\					[034]
			while																\ (0x12)			[014]
				t@																\					[8ff]
				0ff																\					[010]
				+																\					[01e]
				t!																\					[8fe]
				ip++															\					[8fc]
		repeat																	\ (0xffed)			[013 0b2]
		ipc@++																	\					[8fd]
		1f																		\					[010]
		+																		\					[01e]
		t@																		\					[8ff]
		+																		\					[01e]
		t!																		\					[8fe]
	then																		\					[0b2]
	1																			\					[0a6]
	set-mpos																	\					[90d]
	ipc@++																		\					[8fd]
	2																			\					[0a7]
	rshift																		\					[028]
	colon_definition_function_911												\ (911)				[911]
	ipc@++																		\					[8fd]
	6																			\					[010]
	lshift																		\					[027]
	colon_definition_function_911												\ (911)				[911]
	;																			\					[0c2]


: colon_definition_function_91a													\ (91a)				[0b5 0b7]
	0																			\					[0a5]
	set-mpos																	\					[90d]
	t@																			\					[8ff]
	8																			\					[010]
	and																			\					[023]
	0b																			\					[010]
	lshift																		\					[027]
	colon_definition_function_911												\ (911)				[911]
	t@																			\					[8ff]
	7																			\					[010]
	and																			\					[023]
	t!																			\					[8fe]
	t@																			\					[8ff]
	0=																			\					[034]
	if																			\ (0x27)			[014]
		begin																	\					[0b1]
			ipc@																\					[8fb]
			0=																	\					[034]
			while																\ (0x12)			[014]
				t@																\					[8ff]
				0ff																\					[010]
				+																\					[01e]
				t!																\					[8fe]
				ip++															\					[8fc]
		repeat																	\ (0xffed)			[013 0b2]
		ipc@++																	\					[8fd]
		7																		\					[010]
		+																		\					[01e]
		t@																		\					[8ff]
		+																		\					[01e]
		t!																		\					[8fe]
	then																		\					[0b2]
	ipc@++																		\					[8fd]
	2																			\					[0a7]
	rshift																		\					[028]
	colon_definition_function_911												\ (911)				[911]
	ipc@++																		\					[8fd]
	6																			\					[010]
	lshift																		\					[027]
	colon_definition_function_911												\ (911)				[911]
	op@																			\					[900]
	mpos-ptr																	\					[910]
	=																			\					[03c]
	if																			\ (0xa)				[014]
		s_e																		\					[8f5]
		st!																		\					[903]
	else																		\ (0xb)				[013 0b2]
		4000																	\					[010]
		colon_definition_function_911											\ (911)				[911]
	then																		\					[0b2]
	;																			\					[0c2]


: colon_definition_function_91b													\ (91b)				[0b5 0b7]
	1																			\					[0a6]
	set-mpos																	\					[90d]
	t@																			\					[8ff]
	2																			\					[0a7]
	rshift																		\					[028]
	colon_definition_function_911												\ (911)				[911]
	ipc@++																		\					[8fd]
	2																			\					[0a7]
	lshift																		\					[027]
	colon_definition_function_911												\ (911)				[911]
	colon_definition_function_914												\ (914)				[914]
	op++=mpos																	\					[90f]
	s_md																		\					[8f4]
	st!																			\					[903]
	;																			\					[0c2]


: colon_definition_function_91c													\ (91c)				[0b5 0b7]
	s_cm																		\					[8f3]
	st!																			\					[903]
	t@																			\					[8ff]
	3f																			\					[010]
	>																			\					[03b]
	if																			\ (0x8)				[014]
		colon_definition_function_918											\ (918)				[918]
	else																		\ (0x2a)			[013 0b2]
		t@																		\					[8ff]
		1f																		\					[010]
		>																		\					[03b]
		if																		\ (0x8)				[014]
			colon_definition_function_919										\ (919)				[919]
		else																	\ (0x18)			[013 0b2]
			t@																	\					[8ff]
			0f																	\					[010]
			>																	\					[03b]
			if																	\ (0x8)				[014]
				colon_definition_function_91a									\ (91a)				[91a]
			else																\ (0x6)				[013 0b2]
				colon_definition_function_91b									\ (91b)				[91b]
			then																\					[0b2]
		then																	\					[0b2]
	then																		\					[0b2]
	;																			\					[0c2]


: colon_definition_function_91d													\ (91d)				[0b5 0b7]
	colon_definition_function_914												\ (914)				[914]
	colon_definition_function_914												\ (914)				[914]
	begin																		\					[0b1]
		colon_definition_function_914											\ (914)				[914]
		t@																		\					[8ff]
		1-																		\					[0a6 01f]
		t!																		\					[8fe]
		t@																		\					[8ff]
		0=																		\					[034]
	until																		\ (0xfff4)			[014]
	s_md																		\					[8f4]
	st!																			\					[903]
	;																			\					[0c2]


: colon_definition_function_91e													\ (91e)				[0b5 0b7]
	ip																			\					[8f8]
	@																			\					[06d]
	2-																			\					[0a7 01f]
	c@																			\					[071]
	3																			\					[0a8]
	and																			\					[023]
	t!																			\					[8fe]
	t@																			\					[8ff]
	0=																			\					[034]
	if																			\ (0xa)				[014]
		s_m1																	\					[8f0]
		st!																		\					[903]
	else																		\ (0x1b)			[013 0b2]
		begin																	\					[0b1]
			colon_definition_function_913										\ (913)				[913]
			t@																	\					[8ff]
			1-																	\					[0a6 01f]
			t!																	\					[8fe]
			t@																	\					[8ff]
			0=																	\					[034]
		until																	\ (0xfff4)			[014]
		ipc@++																	\					[8fd]
		t!																		\					[8fe]
		s_mt																	\					[8f2]
		st!																		\					[903]
	then																		\					[0b2]
	;																			\					[0c2]



headers

: dtd																			\ (91f)				[0b6 0b7]
	begin																		\					[0b1]
		p_state																	\					[8f6]
		@																		\					[06d]
		case																	\					[0c4]
			s_st																\					[8ef]
			of																	\ (0x7)				[01c]
				colon_definition_function_915									\ (915)				[915]
			endof																\ (0x35)			[0c6]
			s_m1																\					[8f0]
			of																	\ (0x7)				[01c]
				colon_definition_function_916									\ (916)				[916]
			endof																\ (0x2b)			[0c6]
			s_f																	\					[8f1]
			of																	\ (0x7)				[01c]
				colon_definition_function_917									\ (917)				[917]
			endof																\ (0x21)			[0c6]
			s_mt																\					[8f2]
			of																	\ (0x7)				[01c]
				colon_definition_function_91c									\ (91c)				[91c]
			endof																\ (0x17)			[0c6]
			s_cm																\					[8f3]
			of																	\ (0x7)				[01c]
				colon_definition_function_91d									\ (91d)				[91d]
			endof																\ (0xd)				[0c6]
			s_md																\					[8f4]
			of																	\ (0x7)				[01c]
				colon_definition_function_91e									\ (91e)				[91e]
			endof																\ (0x3)				[0c6]
		endcase																	\					[0c5]
		p_state																	\					[8f6]
		@																		\					[06d]
		s_e																		\					[8f5]
		=																		\					[03c]
	until																		\ (0xffb8)			[014]
	;																			\					[0c2]


: init-d																		\ (920)				[0b6 0b7]
	drop																		\					[046]
	4																			\					[010]
	+																			\					[01e]
	ip																			\					[8f8]
	!																			\					[072]
	buflen																		\					[905]
	alloc-mem																	\					[08b]
	to bufst																	\					[0c3 904]
	bufst																		\					[904]
	op																			\					[8f9]
	!																			\					[072]
	s_st																		\					[8ef]
	st!																			\					[903]
	;																			\					[0c2]


: decompress																	\ (921)				[0b6 0b7]
	init-d																		\					[920]
	dtd																			\					[91f]
	flush-buffer																\					[90b]
	bufst																		\					[904]
	buflen																		\					[905]
	free-mem																	\					[08c]
	propadr																		\					[907]
	proplen																		\					[908]
	;																			\					[0c2]


: decompress_property															\ (922)				[0b6 0b7]
	>r																			\					[030]
	>r																			\					[030]
	decompress																	\					[921]
	over																		\					[048]
	0=																			\					[034]
	invert																		\					[026]
	if																			\ (0xa)				[014]
		r>																		\					[031]
		r>																		\					[031]
		property																\					[110]
	else																		\ (0x8)				[013 0b2]
		r>																		\					[031]
		r>																		\					[031]
		2drop																	\					[052]
		2drop																	\					[052]
	then																		\					[0b2]
	;																			\					[0c2]


: read-our-driver																\ (923)				[0b6 0b7]
	rom-map																		\					[8e0]
	-1																			\					[0a4]
	set-second-page																\					[8e2]
	my-rom																		\					[8df]
	10000																		\					[010]
	find-property																\					[8ee]
	0																			\					[0a5]
	set-second-page																\					[8e2]
	dup																			\					[047]
	0=																			\					[034]
	if																			\ (0x20)			[014]
		" MacOS driver not found!"												\					[012]
		warning																	\					[80c]
		2drop																	\					[052]
		exit																	\					[033]
	then																		\					[0b2]
	decompress																	\					[921]
	" driver,AAPL,MacOS,PowerPC"												\					[012]
	property																	\					[110]
	rom-unmap																	\					[8e1]
	;																			\					[0c2]

read-our-driver																	\					[923]
new-device																		\					[11f]
" disk"																			\					[012]
device-name																		\					[201]
" block"																		\					[012]
device-type																		\					[11a]
" sd"																			\					[012]
encode-string																	\					[114]
" compatible"																	\					[012]
property																		\					[110]


external

: dma-alloc																		\ (924)				[0ca 0b7]
	" dma-alloc"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: dma-free																		\ (925)				[0ca 0b7]
	" dma-free"																	\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]



headers

: parent-max-transfer															\ (926)				[0b6 0b7]
	" max-transfer"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: parent-set-address															\ (927)				[0b6 0b7]
	" set-address"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: retry-command																	\ (928)				[0b6 0b7]
	" retry-command"															\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: no-data-command																\ (929)				[0b6 0b7]
	" no-data-command"															\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: short-data-command															\ (92a)				[0b6 0b7]
	" short-data-command"														\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: +c!																			\ (92b)				[0b6 0b7]
	tuck																		\					[04c]
	c!																			\					[075]
	1+																			\					[0a6 01e]
	;																			\					[0c2]


: 3c!																			\ (92c)				[0b6 0b7]
	>r																			\					[030]
	lbsplit																		\					[07e]
	drop																		\					[046]
	r>																			\					[031]
	+c!																			\					[92b]
	+c!																			\					[92b]
	c!																			\					[075]
	;																			\					[0c2]


: -c@																			\ (92d)				[0b6 0b7]
	dup																			\					[047]
	c@																			\					[071]
	swap																		\					[049]
	1-																			\					[0a6 01f]
	;																			\					[0c2]


: 3c@																			\ (92e)				[0b6 0b7]
	2+																			\					[0a7 01e]
	-c@																			\					[92d]
	-c@																			\					[92d]
	c@																			\					[071]
	0																			\					[0a5]
	bljoin																		\					[07f]
	;																			\					[0c2]


: 4c@																			\ (92f)				[0b6 0b7]
	3																			\					[0a8]
	+																			\					[01e]
	-c@																			\					[92d]
	-c@																			\					[92d]
	-c@																			\					[92d]
	c@																			\					[071]
	bljoin																		\					[07f]
	;																			\					[0c2]

0a constant /cmdbuf																\ (930 0a)			[010 0b6 0ba]
create cmdbuf																	\ (931)				[0b6 0bb]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]

: cb!																			\ (932)				[0b6 0b7]
	cmdbuf																		\					[931]
	+																			\					[01e]
	c!																			\					[075]
	;																			\					[0c2]

create eject-cmd																\ (933)				[0b6 0bb]
1b																				\					[010]
c,																				\					[0d0]
1																				\					[0a6]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
2																				\					[0a7]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]


external

: device-present?																\ (934)				[0ca 0b7]
	parent-set-address															\					[927]
	0=																			\					[034]
	if																			\ (0x5)				[014]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	5																			\					[010]
	" inquiry"																	\					[012]
	$call-parent																\					[209]
	invert																		\					[026]
	;																			\					[0c2]


: eject																			\ (935)				[0ca 0b7]
	my-unit																		\					[20d]
	device-present?																\					[934]
	if																			\ (0x8)				[014]
		eject-cmd																\					[933]
		no-data-command															\					[929]
		drop																	\					[046]
	then																		\					[0b2]
	;																			\					[0c2]


headers

0 instance value deblocker														\ (936 0)			[0a5 0c0 0b6 0b8]

: init-deblocker																\ (937)				[0b6 0b7]
	" "																			\					[012]
	" deblocker"																\					[012]
	$open-package																\					[20f]
	to deblocker																\					[0c3 936]
	deblocker																	\					[936]
	if																			\ (0x7)				[014]
		-1																		\					[0a4]
	else																		\ (0x25)			[013 0b2]
		." Can't open deblocker package"										\					[012 090]
		cr																		\					[092]
		0																		\					[0a5]
	then																		\					[0b2]
	;																			\					[0c2]


: set-timeout																	\ (938)				[0b6 0b7]
	" set-timeout"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]

0 instance value offset-low														\ (939 0)			[0a5 0c0 0b6 0b8]
0 instance value offset-high													\ (93a 0)			[0a5 0c0 0b6 0b8]

external

0 instance value label-package													\ (93b 0)			[0a5 0c0 0ca 0b8]
-1 value report-failure															\ (93c -1)			[0a4 0ca 0b8]


headers

: init-label-package															\ (93d)				[0b6 0b7]
	0																			\					[0a5]
	to offset-high																\					[0c3 93a]
	0																			\					[0a5]
	to offset-low																\					[0c3 939]
	my-args																		\					[202]
	" disk-label"																\					[012]
	$open-package																\					[20f]
	to label-package															\					[0c3 93b]
	label-package																\					[93b]
	dup																			\					[047]
	if																			\ (0x1a)			[014]
		0																		\					[0a5]
		0																		\					[0a5]
		" offset"																\					[012]
		label-package															\					[93b]
		$call-method															\					[20e]
		to offset-high															\					[0c3 93a]
		to offset-low															\					[0c3 939]
	else																		\ (0x2b)			[013 0b2]
		report-failure															\					[93c]
		if																		\ (0x24)			[014]
			." Can't open disk label package"									\					[012 090]
			cr																	\					[092]
		then																	\					[0b2]
	then																		\					[0b2]
	;																			\					[0c2]

create sstart-cmd																\ (93e)				[0b6 0bb]
1b																				\					[010]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
1																				\					[0a6]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]

: timed-spin																	\ (93f)				[0b6 0b7]
	2d																			\					[010]
	3e8																			\					[010]
	*																			\					[020]
	set-timeout																	\					[938]
	0																			\					[0a5]
	0																			\					[0a5]
	-1																			\					[0a4]
	sstart-cmd																	\					[93e]
	6																			\					[010]
	-1																			\					[0a4]
	retry-command																\					[928]
	if																			\ (0x18)			[014]
		if																		\ (0x7)				[014]
			-1																	\					[0a4]
		else																	\ (0xd)				[013 0b2]
			2+																	\					[0a7 01e]
			c@																	\					[071]
			5																	\					[010]
			<>																	\					[03d]
		then																	\					[0b2]
	else																		\ (0x5)				[013 0b2]
		0																		\					[0a5]
	then																		\					[0b2]
	0																			\					[0a5]
	set-timeout																	\					[938]
	;																			\					[0c2]

0 instance value /block															\ (940 0)			[0a5 0c0 0b6 0b8]
create mode-sense-bd															\ (941)				[0b6 0bb]
1a																				\					[010]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0c																				\					[010]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
create read-capacity-cmd														\ (942)				[0b6 0bb]
25																				\					[010]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]

: read-block-extent																\ (943)				[0b6 0b7]
	8																			\					[010]
	read-capacity-cmd															\					[942]
	0a																			\					[010]
	short-data-command															\					[92a]
	0=																			\					[034]
	if																			\ (0x13)			[014]
		dup																		\					[047]
		4																		\					[010]
		+																		\					[01e]
		4c@																		\					[92f]
		swap																	\					[049]
		4c@																		\					[92f]
		1+																		\					[0a6 01e]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	0c																			\					[010]
	mode-sense-bd																\					[941]
	6																			\					[010]
	short-data-command															\					[92a]
	0=																			\					[034]
	if																			\ (0x17)			[014]
		dup																		\					[047]
		9																		\					[010]
		+																		\					[01e]
		3c@																		\					[92e]
		swap																	\					[049]
		4																		\					[010]
		+																		\					[01e]
		4c@																		\					[92f]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	-1																			\					[0a4]
	;																			\					[0c2]


: read-block-size																\ (944)				[0b6 0b7]
	read-block-extent															\					[943]
	if																			\ (0xb)				[014]
		200																		\					[010]
	else																		\ (0x5)				[013 0b2]
		drop																	\					[046]
	then																		\					[0b2]
	;																			\					[0c2]



external

: #blocks																		\ (945)				[0ca 0b7]
	read-block-extent															\					[943]
	if																			\ (0x7)				[014]
		-1																		\					[0a4]
	else																		\ (0x5)				[013 0b2]
		nip																		\					[04d]
	then																		\					[0b2]
	;																			\					[0c2]


: block-size																	\ (946)				[0ca 0b7]
	/block																		\					[940]
	if																			\ (0x6)				[014]
		/block																	\					[940]
		exit																	\					[033]
	then																		\					[0b2]
	read-block-size																\					[944]
	dup																			\					[047]
	to /block																	\					[0c3 940]
	;																			\					[0c2]



headers

: 2c!																			\ (947)				[0b6 0b7]
	>r																			\					[030]
	lbsplit																		\					[07e]
	2drop																		\					[052]
	r>																			\					[031]
	+c!																			\					[92b]
	c!																			\					[075]
	;																			\					[0c2]


: 4c!																			\ (948)				[0b6 0b7]
	>r																			\					[030]
	lbsplit																		\					[07e]
	r>																			\					[031]
	+c!																			\					[92b]
	+c!																			\					[92b]
	+c!																			\					[92b]
	c!																			\					[075]
	;																			\					[0c2]


: r/w-blocks																	\ (949)				[0b6 0b7]
	cmdbuf																		\					[931]
	/cmdbuf																		\					[930]
	erase																		\					[0a5 079]
	2over																		\					[054]
	100																			\					[010]
	u>																			\					[03e]
	swap																		\					[049]
	200000																		\					[010]
	u>=																			\					[041]
	or																			\					[024]
	if																			\ (0x27)			[014]
		20																		\					[010]
		or																		\					[024]
		0																		\					[0a5]
		cb!																		\					[932]
		-rot																	\					[04b]
		swap																	\					[049]
		cmdbuf																	\					[931]
		2+																		\					[0a7 01e]
		4c!																		\					[948]
		dup																		\					[047]
		cmdbuf																	\					[931]
		7																		\					[010]
		+																		\					[01e]
		2c!																		\					[947]
		0a																		\					[010]
	else																		\ (0x1c)			[013 0b2]
		0																		\					[0a5]
		cb!																		\					[932]
		-rot																	\					[04b]
		swap																	\					[049]
		cmdbuf																	\					[931]
		1+																		\					[0a6 01e]
		3c!																		\					[92c]
		dup																		\					[047]
		4																		\					[010]
		cb!																		\					[932]
		6																		\					[010]
	then																		\					[0b2]
	swap																		\					[049]
	dup																			\					[047]
	>r																			\					[030]
	/block																		\					[940]
	*																			\					[020]
	-rot																		\					[04b]
	cmdbuf																		\					[931]
	swap																		\					[049]
	-1																			\					[0a4]
	retry-command																\					[928]
	if																			\ (0xf)				[014]
		0=																		\					[034]
		if																		\ (0x4)				[014]
			drop																\					[046]
		then																	\					[0b2]
		r>																		\					[031]
		drop																	\					[046]
		0																		\					[0a5]
	else																		\ (0x5)				[013 0b2]
		r>																		\					[031]
	then																		\					[0b2]
	;																			\					[0c2]



external

: max-transfer																	\ (94a)				[0ca 0b7]
	parent-max-transfer															\					[926]
	;																			\					[0c2]


: read-blocks																	\ (94b)				[0ca 0b7]
	-1																			\					[0a4]
	8																			\					[010]
	r/w-blocks																	\					[949]
	;																			\					[0c2]


: write-blocks																	\ (94c)				[0ca 0b7]
	0																			\					[0a5]
	0a																			\					[010]
	r/w-blocks																	\					[949]
	;																			\					[0c2]


: open																			\ (94d)				[0ca 0b7]
	my-unit																		\					[20d]
	" set-address"																\					[012]
	$call-parent																\					[209]
	timed-spin																	\					[93f]
	if																			\ (0x5)				[014]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	block-size																	\					[946]
	to /block																	\					[0c3 940]
	init-deblocker																\					[937]
	0=																			\					[034]
	if																			\ (0x5)				[014]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	init-label-package															\					[93d]
	0=																			\					[034]
	if																			\ (0x9)				[014]
		deblocker																\					[936]
		close-package															\					[206]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	-1																			\					[0a4]
	;																			\					[0c2]


: close																			\ (94e)				[0ca 0b7]
	label-package																\					[93b]
	close-package																\					[206]
	deblocker																	\					[936]
	close-package																\					[206]
	;																			\					[0c2]


: seek																			\ (94f)				[0ca 0b7]
	offset-low																	\					[939]
	offset-high																	\					[93a]
	d+																			\					[0d8]
	" seek"																		\					[012]
	deblocker																	\					[936]
	$call-method																\					[20e]
	;																			\					[0c2]


: read																			\ (950)				[0ca 0b7]
	" read"																		\					[012]
	deblocker																	\					[936]
	$call-method																\					[20e]
	;																			\					[0c2]


: write																			\ (951)				[0ca 0b7]
	" write"																	\					[012]
	deblocker																	\					[936]
	$call-method																\					[20e]
	;																			\					[0c2]


: load																			\ (952)				[0ca 0b7]
	" load"																		\					[012]
	label-package																\					[93b]
	$call-method																\					[20e]
	;																			\					[0c2]


: size																			\ (953)				[0ca 0b7]
	" size"																		\					[012]
	label-package																\					[93b]
	$call-method																\					[20e]
	;																			\					[0c2]

finish-device																	\					[127]
new-device																		\					[11f]
" tape"																			\					[012]
device-name																		\					[201]
" byte"																			\					[012]
device-type																		\					[11a]
" st"																			\					[012]
encode-string																	\					[114]
" compatible"																	\					[012]
property																		\					[110]

: dma-alloc																		\ (954)				[0ca 0b7]
	" dma-alloc"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: dma-free																		\ (955)				[0ca 0b7]
	" dma-free"																	\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]



headers

: parent-max-transfer															\ (956)				[0b6 0b7]
	" max-transfer"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: parent-set-address															\ (957)				[0b6 0b7]
	" set-address"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: retry-command																	\ (958)				[0b6 0b7]
	" retry-command"															\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: no-data-command																\ (959)				[0b6 0b7]
	" no-data-command"															\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: short-data-command															\ (95a)				[0b6 0b7]
	" short-data-command"														\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: +c!																			\ (95b)				[0b6 0b7]
	tuck																		\					[04c]
	c!																			\					[075]
	1+																			\					[0a6 01e]
	;																			\					[0c2]


: 3c!																			\ (95c)				[0b6 0b7]
	>r																			\					[030]
	lbsplit																		\					[07e]
	drop																		\					[046]
	r>																			\					[031]
	+c!																			\					[95b]
	+c!																			\					[95b]
	c!																			\					[075]
	;																			\					[0c2]


: -c@																			\ (95d)				[0b6 0b7]
	dup																			\					[047]
	c@																			\					[071]
	swap																		\					[049]
	1-																			\					[0a6 01f]
	;																			\					[0c2]


: 3c@																			\ (95e)				[0b6 0b7]
	2+																			\					[0a7 01e]
	-c@																			\					[95d]
	-c@																			\					[95d]
	c@																			\					[071]
	0																			\					[0a5]
	bljoin																		\					[07f]
	;																			\					[0c2]


: 4c@																			\ (95f)				[0b6 0b7]
	3																			\					[0a8]
	+																			\					[01e]
	-c@																			\					[95d]
	-c@																			\					[95d]
	-c@																			\					[95d]
	c@																			\					[071]
	bljoin																		\					[07f]
	;																			\					[0c2]

0a constant /cmdbuf																\ (960 0a)			[010 0b6 0ba]
create cmdbuf																	\ (961)				[0b6 0bb]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]

: cb!																			\ (962)				[0b6 0b7]
	cmdbuf																		\					[961]
	+																			\					[01e]
	c!																			\					[075]
	;																			\					[0c2]

create eject-cmd																\ (963)				[0b6 0bb]
1b																				\					[010]
c,																				\					[0d0]
1																				\					[0a6]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
2																				\					[0a7]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]


external

: device-present?																\ (964)				[0ca 0b7]
	parent-set-address															\					[957]
	0=																			\					[034]
	if																			\ (0x5)				[014]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	5																			\					[010]
	" inquiry"																	\					[012]
	$call-parent																\					[209]
	invert																		\					[026]
	;																			\					[0c2]


: eject																			\ (965)				[0ca 0b7]
	my-unit																		\					[20d]
	device-present?																\					[964]
	if																			\ (0x8)				[014]
		eject-cmd																\					[963]
		no-data-command															\					[959]
		drop																	\					[046]
	then																		\					[0b2]
	;																			\					[0c2]


headers

0 instance value deblocker														\ (966 0)			[0a5 0c0 0b6 0b8]

: init-deblocker																\ (967)				[0b6 0b7]
	" "																			\					[012]
	" deblocker"																\					[012]
	$open-package																\					[20f]
	to deblocker																\					[0c3 966]
	deblocker																	\					[966]
	if																			\ (0x7)				[014]
		-1																		\					[0a4]
	else																		\ (0x25)			[013 0b2]
		." Can't open deblocker package"										\					[012 090]
		cr																		\					[092]
		0																		\					[0a5]
	then																		\					[0b2]
	;																			\					[0c2]


external

0 instance value at-eof?														\ (968 0)			[0a5 0c0 0ca 0b8]

headers

0 instance value fixed-len?														\ (969 0)			[0a5 0c0 0b6 0b8]
0 instance value written?														\ (96a 0)			[0a5 0c0 0b6 0b8]
0 instance value /tapeblock														\ (96b 0)			[0a5 0c0 0b6 0b8]
create write-eof-cmd															\ (96c)				[0b6 0bb]
10																				\					[010]
c,																				\					[0d0]
1																				\					[0a6]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
1																				\					[0a6]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]


external

: write-eof																		\ (96d)				[0ca 0b7]
	write-eof-cmd																\					[96c]
	no-data-command																\					[959]
	;																			\					[0c2]



headers

: ?write-eof																	\ (96e)				[0b6 0b7]
	written?																	\					[96a]
	if																			\ (0x27)			[014]
		0																		\					[0a5]
		to written?																\					[0c3 96a]
		write-eof																\					[96d]
		if																		\ (0x1d)			[014]
			." Can't write file mark."											\					[012 090]
			cr																	\					[092]
		then																	\					[0b2]
	then																		\					[0b2]
	;																			\					[0c2]

create rewind-cmd																\ (96f)				[0b6 0bb]
1																				\					[0a6]
c,																				\					[0d0]
1																				\					[0a6]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]

: rewind																		\ (970)				[0b6 0b7]
	?write-eof																	\					[96e]
	0																			\					[0a5]
	to at-eof?																	\					[0c3 968]
	rewind-cmd																	\					[96f]
	no-data-command																\					[959]
	;																			\					[0c2]

create skip-files-cmd															\ (971)				[0b6 0bb]
11																				\					[010]
c,																				\					[0d0]
1																				\					[0a6]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]

: skip-files																	\ (972)				[0b6 0b7]
	?write-eof																	\					[96e]
	0																			\					[0a5]
	to at-eof?																	\					[0c3 968]
	skip-files-cmd																\					[971]
	2+																			\					[0a7 01e]
	3c!																			\					[95c]
	skip-files-cmd																\					[971]
	no-data-command																\					[959]
	;																			\					[0c2]

create block-limit-cmd															\ (973)				[0b6 0bb]
5																				\					[010]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]

: 2c@																			\ (974)				[0b6 0b7]
	1+																			\					[0a6 01e]
	-c@																			\					[95d]
	c@																			\					[071]
	bwjoin																		\					[0b0]
	;																			\					[0c2]


: get-record-length																\ (975)				[0b6 0b7]
	6																			\					[010]
	block-limit-cmd																\					[973]
	6																			\					[010]
	short-data-command															\					[95a]
	if																			\ (0xc)				[014]
		200																		\					[010]
		-1																		\					[0a4]
	else																		\ (0x14)			[013 0b2]
		dup																		\					[047]
		1+																		\					[0a6 01e]
		3c@																		\					[95e]
		swap																	\					[049]
		4																		\					[010]
		+																		\					[01e]
		2c@																		\					[974]
		over																	\					[048]
		=																		\					[03c]
	then																		\					[0b2]
	to fixed-len?																\					[0c3 969]
	dup																			\					[047]
	parent-max-transfer															\					[956]
	u>																			\					[03e]
	if																			\ (0x6)				[014]
		drop																	\					[046]
		parent-max-transfer														\					[956]
	then																		\					[0b2]
	to /tapeblock																\					[0c3 96b]
	;																			\					[0c2]

-1 instance value first-install?												\ (976 -1)			[0a4 0c0 0b6 0b8]

: ili?																			\ (977)				[0b6 0b7]
	2+																			\					[0a7 01e]
	c@																			\					[071]
	20																			\					[010]
	and																			\					[023]
	0<>																			\					[035]
	;																			\					[0c2]


: eof?																			\ (978)				[0b6 0b7]
	dup																			\					[047]
	2+																			\					[0a7 01e]
	c@																			\					[071]
	0c0																			\					[010]
	and																			\					[023]
	0<>																			\					[035]
	swap																		\					[049]
	3																			\					[0a8]
	+																			\					[01e]
	c@																			\					[071]
	0f																			\					[010]
	and																			\					[023]
	8																			\					[010]
	=																			\					[03c]
	or																			\					[024]
	;																			\					[0c2]


: residue																		\ (979)				[0b6 0b7]
	3																			\					[0a8]
	+																			\					[01e]
	4c@																			\					[95f]
	;																			\					[0c2]

0 instance value #requested														\ (97a 0)			[0a5 0c0 0b6 0b8]

: actual-#blocks																\ (97b)				[0b6 0b7]
	if																			\ (0x25)			[014]
		if																		\ (0x8)				[014]
			0																	\					[0a5]
			0																	\					[0a5]
		else																	\ (0x19)			[013 0b2]
			>r																	\					[030]
			#requested															\					[97a]
			r@																	\					[032]
			ili?																\					[977]
			r@																	\					[032]
			eof?																\					[978]
			or																	\					[024]
			if																	\ (0x7)				[014]
				r@																\					[032]
				residue															\					[979]
				-																\					[01f]
			then																\					[0b2]
			r>																	\					[031]
			eof?																\					[978]
		then																	\					[0b2]
	else																		\ (0x7)				[013 0b2]
		#requested																\					[97a]
		0																		\					[0a5]
	then																		\					[0b2]
	to at-eof?																	\					[0c3 968]
	;																			\					[0c2]


: r/w-some																		\ (97c)				[0b6 0b7]
	cmdbuf																		\					[961]
	/cmdbuf																		\					[960]
	erase																		\					[0a5 079]
	0																			\					[0a5]
	cb!																			\					[962]
	swap																		\					[049]
	fixed-len?																	\					[969]
	if																			\ (0x10)			[014]
		dup																		\					[047]
		to #requested															\					[0c3 97a]
		dup																		\					[047]
		/tapeblock																\					[96b]
		*																		\					[020]
		swap																	\					[049]
		1																		\					[0a6]
	else																		\ (0xd)				[013 0b2]
		/tapeblock																\					[96b]
		min																		\					[02e]
		dup																		\					[047]
		to #requested															\					[0c3 97a]
		dup																		\					[047]
		0																		\					[0a5]
	then																		\					[0b2]
	1																			\					[0a6]
	cb!																			\					[962]
	cmdbuf																		\					[961]
	2+																			\					[0a7 01e]
	3c!																			\					[95c]
	swap																		\					[049]
	cmdbuf																		\					[961]
	6																			\					[010]
	-1																			\					[0a4]
	retry-command																\					[958]
	actual-#blocks																\					[97b]
	;																			\					[0c2]


: flush-deblocker																\ (97d)				[0b6 0b7]
	deblocker																	\					[966]
	close-package																\					[206]
	init-deblocker																\					[967]
	drop																		\					[046]
	;																			\					[0c2]

0 instance value load-arg-adr													\ (97e 0)			[0a5 0c0 0b6 0b8]
0 instance value load-arg-len													\ (97f 0)			[0a5 0c0 0b6 0b8]

: set-load-args																	\ (980)				[0b6 0b7]
	to load-arg-len																\					[0c3 97f]
	to load-arg-adr																\					[0c3 97e]
	;																			\					[0c2]


: $=																			\ (981)				[0b6 0b7]
	rot																			\					[04a]
	tuck																		\					[04c]
	<>																			\					[03d]
	if																			\ (0x7)				[014]
		3drop																	\					[8ed]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	comp																		\					[07a]
	0=																			\					[034]
	;																			\					[0c2]


: handle-options																\ (982)				[0b6 0b7]
	my-args																		\					[202]
	dup																			\					[047]
	if																			\ (0x2c)			[014]
		2c																		\					[010]
		left-parse-string														\					[240]
		2dup																	\					[053]
		" fixed"																\					[012]
		$=																		\					[981]
		if																		\ (0x13)			[014]
			2drop																\					[052]
			set-load-args														\					[980]
			200																	\					[010]
			to /tapeblock														\					[0c3 96b]
			-1																	\					[0a4]
			to fixed-len?														\					[0c3 969]
			exit																\					[033]
		then																	\					[0b2]
		2drop																	\					[052]
		2drop																	\					[052]
		my-args																	\					[202]
	then																		\					[0b2]
	set-load-args																\					[980]
	;																			\					[0c2]



external

: max-transfer																	\ (983)				[0ca 0b7]
	fixed-len?																	\					[969]
	if																			\ (0xe)				[014]
		parent-max-transfer														\					[956]
		/tapeblock																\					[96b]
		/																		\					[021]
		/tapeblock																\					[96b]
		*																		\					[020]
	else																		\ (0x6)				[013 0b2]
		/tapeblock																\					[96b]
	then																		\					[0b2]
	;																			\					[0c2]


: block-size																	\ (984)				[0ca 0b7]
	fixed-len?																	\					[969]
	if																			\ (0x8)				[014]
		/tapeblock																\					[96b]
	else																		\ (0x5)				[013 0b2]
		1																		\					[0a6]
	then																		\					[0b2]
	;																			\					[0c2]


: read-blocks																	\ (985)				[0ca 0b7]
	nip																			\					[04d]
	at-eof?																		\					[968]
	if																			\ (0x6)				[014]
		2drop																	\					[052]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	-1																			\					[0a4]
	8																			\					[010]
	r/w-some																	\					[97c]
	;																			\					[0c2]


: write-blocks																	\ (986)				[0ca 0b7]
	nip																			\					[04d]
	-1																			\					[0a4]
	to written?																	\					[0c3 96a]
	0																			\					[0a5]
	0a																			\					[010]
	r/w-some																	\					[97c]
	;																			\					[0c2]


: read																			\ (987)				[0ca 0b7]
	" read"																		\					[012]
	deblocker																	\					[966]
	$call-method																\					[20e]
	;																			\					[0c2]


: write																			\ (988)				[0ca 0b7]
	" write"																	\					[012]
	deblocker																	\					[966]
	$call-method																\					[20e]
	flush-deblocker																\					[97d]
	;																			\					[0c2]


: open																			\ (989)				[0ca 0b7]
	my-unit																		\					[20d]
	" set-address"																\					[012]
	$call-parent																\					[209]
	first-install?																\					[976]
	if																			\ (0x24)			[014]
		rewind																	\					[970]
		if																		\ (0x1a)			[014]
			." Can't rewind tape"												\					[012 090]
			cr																	\					[092]
			0																	\					[0a5]
			exit																\					[033]
		then																	\					[0b2]
		0																		\					[0a5]
		to first-install?														\					[0c3 976]
	then																		\					[0b2]
	get-record-length															\					[975]
	handle-options																\					[982]
	init-deblocker																\					[967]
	;																			\					[0c2]


: close																			\ (98a)				[0ca 0b7]
	deblocker																	\					[966]
	close-package																\					[206]
	?write-eof																	\					[96e]
	;																			\					[0c2]

0 value buf																		\ (98b 0)			[0a5 0ca 0b8]
200 constant /buf																\ (98c 200)			[010 0ca 0ba]

: seek																			\ (98d)				[0ca 0b7]
	flush-deblocker																\					[97d]
	rewind																		\					[970]
	if																			\ (0x6)				[014]
		2drop																	\					[052]
		-1																		\					[0a4]
		exit																	\					[033]
	then																		\					[0b2]
	?dup																		\					[050]
	if																			\ (0xc)				[014]
		skip-files																\					[972]
		if																		\ (0x6)				[014]
			drop																\					[046]
			-1																	\					[0a4]
			exit																\					[033]
		then																	\					[0b2]
	then																		\					[0b2]
	?dup																		\					[050]
	if																			\ (0x2b)			[014]
		/buf																	\					[98c]
		alloc-mem																\					[08b]
		to buf																	\					[0c3 98b]
		begin																	\					[0b1]
			dup																	\					[047]
			0>																	\					[038]
			while																\ (0x18)			[014]
				buf																\					[98b]
				over															\					[048]
				/buf															\					[98c]
				min																\					[02e]
				read															\					[987]
				dup																\					[047]
				0=																\					[034]
				if																\ (0x6)				[014]
					2drop														\					[052]
					-1															\					[0a4]
					exit														\					[033]
				then															\					[0b2]
				-																\					[01f]
		repeat																	\ (0xffe8)			[013 0b2]
		drop																	\					[046]
		buf																		\					[98b]
		/buf																	\					[98c]
		free-mem																\					[08c]
	then																		\					[0b2]
	0																			\					[0a5]
	;																			\					[0c2]


: load																			\ (98e)				[0ca 0b7]
	load-arg-len																\					[97f]
	if																			\ (0x2e)			[014]
		load-arg-adr															\					[97e]
		load-arg-len															\					[97f]
		$number																	\					[0a2]
		if																		\ (0x22)			[014]
			." Invalid tape file number"										\					[012 090]
			cr																	\					[092]
			drop																\					[046]
			0																	\					[0a5]
			exit																\					[033]
		then																	\					[0b2]
	else																		\ (0x5)				[013 0b2]
		0																		\					[0a5]
	then																		\					[0b2]
	0																			\					[0a5]
	swap																		\					[049]
	seek																		\					[98d]
	if																			\ (0x2d)			[014]
		." Can't select the requested tape file"								\					[012 090]
		cr																		\					[092]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	70000000																	\					[010]
	read																		\					[987]
	;																			\					[0c2]

finish-device																	\					[127]

fcode-end
\ detokenizing finished after 16647 of 16647 bytes.

pci-end
